(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     18160,        388]
NotebookOptionsPosition[     17585,        370]
NotebookOutlinePosition[     17983,        386]
CellTagsIndexPosition[     17940,        383]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.78065474037152*^9, 3.780654745103043*^9}},
 FontSize->24,
 CellLabel->"In[19]:=",ExpressionUUID->"61cb40ff-a23d-4d33-b5b3-d1c34818e87f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Gasteiger", " ", "and", " ", "Prettner", " ", 
    RowBox[{"(", 
     RowBox[{"2022", ",", " ", 
      RowBox[{"p", ".230"}], ",", " ", 
      RowBox[{"Figure", " ", "1"}]}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Last", " ", 
     RowBox[{"checked", ":", " ", 
      RowBox[{"February", " ", "21", "st"}]}]}], ",", "2022"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "=", 
     RowBox[{"1", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", 
     RowBox[{"0.98", "^", "25"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "1.00"}], ";", " ", 
    RowBox[{"(*", 
     RowBox[{"CANONICAL", " ", "MODEL"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Delta]", "=", "0.50"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BEPlot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Beta]", "*", 
             FractionBox[
              RowBox[{"(", 
               RowBox[{"\[Alpha]", "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  FractionBox[
                   RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"], ")"}], 
                 RowBox[{"1", "-", "\[Alpha]"}]]}], ")"}], 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Phi]"}], ")"}]]}], ")"}], 
           RowBox[{"1", "/", "\[Theta]"}]], ")"}], "-", "1"}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"-", "1"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "11"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0.2"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\[Phi]\>\"", ",", 
          "\"\<\!\(\*FractionBox[\(\*SubscriptBox[\(c\), \(t + 1\)] - \
\*SubscriptBox[\(c\), \(t\)]\), SubscriptBox[\(c\), \(t\)]]\)\>\""}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"AxesStyle", "\[Rule]", 
        RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "5", ",", "10", ",", 
            "15", ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "0.5"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{"BEPlot", ",", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<0\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.15"}], ",", "0.02"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<./figures/Barro_Bequest_Canonical.pdf\>\"", ",", "%"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Theta]", ",", "\[Delta]", ",", 
     "BEPlot"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.780829054078871*^9, 3.78082905835756*^9}, {
   3.7808290947322493`*^9, 3.780829281067875*^9}, {3.780829312618897*^9, 
   3.7808293327624617`*^9}, {3.7808293774815617`*^9, 3.780829426492977*^9}, {
   3.780829591366831*^9, 3.780829756183691*^9}, {3.780829787830482*^9, 
   3.780829787965263*^9}, {3.7808298375641108`*^9, 3.780829837851034*^9}, {
   3.780829880721751*^9, 3.780829881457923*^9}, {3.780829914392807*^9, 
   3.7808300193411207`*^9}, {3.780830077273662*^9, 3.780830199243375*^9}, {
   3.780830235842422*^9, 3.780830244688986*^9}, {3.7808302748730173`*^9, 
   3.780830553715728*^9}, {3.7808305841313543`*^9, 3.780830834137381*^9}, {
   3.78083089902172*^9, 3.780830911891734*^9}, {3.78083094562766*^9, 
   3.7808309643614798`*^9}, {3.7808311317712393`*^9, 3.780831159040996*^9}, {
   3.78083119661789*^9, 3.780831238910396*^9}, {3.7808312767168093`*^9, 
   3.780831294885303*^9}, 3.780831337482305*^9, {3.780831409095214*^9, 
   3.780831458563259*^9}, {3.780832222458493*^9, 3.7808322613342752`*^9}, {
   3.7808324219357243`*^9, 3.780832448197504*^9}, {3.7808324841974287`*^9, 
   3.780832499155232*^9}, {3.780832568167369*^9, 3.780832655236124*^9}, {
   3.7808326857554903`*^9, 3.780832685923098*^9}, {3.781193867135646*^9, 
   3.781193896193099*^9}, {3.781193938655344*^9, 3.78119402422206*^9}, {
   3.781194056412602*^9, 3.781194109650539*^9}, {3.781194143735558*^9, 
   3.781194260760529*^9}, {3.781194306935298*^9, 3.781194316311244*^9}, {
   3.7811943526344213`*^9, 3.7811943772341413`*^9}, {3.7811944088837957`*^9, 
   3.7811944374314013`*^9}, 3.7811944996333714`*^9, {3.78142834792719*^9, 
   3.7814283522222958`*^9}, {3.7814284140373583`*^9, 3.781428425466799*^9}, {
   3.781428707438936*^9, 3.7814287076713457`*^9}, 3.7814296147040663`*^9, {
   3.7814300342039433`*^9, 3.781430034892192*^9}, {3.781430289897513*^9, 
   3.781430301847206*^9}, {3.781694223126583*^9, 3.781694411156929*^9}, {
   3.7816944870187273`*^9, 3.781694569453903*^9}, {3.7817946907968073`*^9, 
   3.781794745122409*^9}, {3.781794791305727*^9, 3.7817949655604153`*^9}, {
   3.781795017200163*^9, 3.781795017300078*^9}, {3.7817952854986467`*^9, 
   3.781795356301564*^9}, {3.7817953948088284`*^9, 3.781795394911118*^9}, {
   3.7817954269554787`*^9, 3.781795481910397*^9}, {3.7817955369079733`*^9, 
   3.7817955536873693`*^9}, {3.781860485033517*^9, 3.7818604973525352`*^9}, {
   3.7818605391583433`*^9, 3.781860561109333*^9}, {3.7818606134211206`*^9, 
   3.7818606456049747`*^9}, {3.854429517703801*^9, 3.854429539420205*^9}, {
   3.854429611362142*^9, 3.854429723076166*^9}, 3.854429902022983*^9, {
   3.854429935222316*^9, 3.8544299421648684`*^9}, {3.854431346110737*^9, 
   3.854431346278295*^9}},
 FontSize->24,ExpressionUUID->"1efe1ae8-7d37-4d89-953e-fb6ab9612246"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV03k01PsbB3BblC1bipRliKKbSmTJ52uXW6QbFZJkqdxLlMjSRaVokVKh
lBshewmlqwfXvhQxmjCMMfuYr7GUCfGb33POc57z+uN9znPOcx5t/7DDgWIi
IiKNwv7/3J6l2JQSw4TsrP9XB7qokeFANGPCMaW4pZd4M+LUOMmOqTHBmD+b
sOdnE/JzX/zCWmSAyNsdbR0KjehAsr/fEjAg11BZX66zDunyjWMJzgxo+Bpm
ZONRjLJTaTbbtzHAbzM24sLLQwp6mavNZBmQEDXe13P0CVo6vvLQpZcOIl9O
xLhEn0UD//VUhh+jQ674PkrOz3xw8U2MirWgA+ZQnxfmVgwNAhPr6xp04Pu+
IdJuVEDp9qddmRQaJBTccDf78hauPT7HgDM0wCJErvLcP8LCzs1lHS40UFhj
ov3v/gY43913od+IBkYl2jqdAY3gI2ouyuRPAOV75KVzqf+BSYiUhvzlCfDD
NzrIZrZB8aoP1PXeE2BV4GF1Ia0dtHJDX2nvm4DSV39FHkrqAFki0XSP6ARk
eDpYcr26gGad7+6TQgV7z35S/9AneKBkc6M4axx20Ytw/sMv0F1Ez6yMHwff
UfXfk3hfQAKlFtecGgcRakpss10/XAzp72naKvS3o4LoyX7wbA5UGX5PgVYT
EjVwBxGMJ1Xs1r8dA3yrWEN3wlfI3eAbRIgbA4VPGwfiWr+CokNhyg77MfDX
UCqxliHBTI55r9PAKPhL8KKk75Og2s33RPQcGRpMVfLRw29gUVUY9c1kBO75
mv9RFjkMxWP8bPrSMDyltDtdKB+GjbIWH6ebh2FzUsp4CmMYlgK6JaQ9hmFh
PD2t+sgIgOp0ukXkEGSo37vltZUM9jEWpU+qSbCcWNaL1YzC24KrnwvjSdBQ
GocF0kdBr797psqBBENkKl1CZQwkjU6adxO/QnTvgfiPYWPQQb7auvR9EPK9
6uKLFSjgatNDOWFKBC/Dv6x9aynQ/clpOWllAM59kPYhd1LAxadpY1H7ADjX
yyxuG6WAU1St54zXACxYVBeaSIwDVvZPd/Lf/fDGp8N7nes47FS79K6ivQ8i
lNrsn30bh8oCPnEgvQ+8O/ZOenDG4TeTkNmfXn2Qagw2jIVx2Obm95s9rxdi
EsY1Hmykgs51l3ySYi/8ffedkpE3FfSp+7TEa7ohlHD8Yls/FXR/7fI+6NwN
eJJclgOVClobDB49HuqC8PWDS3l8KmxwVZI1WumEgq4bmuJyEyBdx5g/4twB
Q5rfGz3sJ2AyPe1zwVAL9CafevOsbAICrjb9yliuh56Vfn3Jv2gwlMK7ck+h
HtgpFf1bL9Pg0L0NIrd1/oXyLkeCyXUaWOWEil11rINH6wWsX09poFyrLhV+
twY+DaLg0C4aXCPStbKtykGi89IGMV06NKx9lZ4u5gaNf469edtCBw+eySXu
SiBq0Ppwx/gzHQ6uPVe0j3IZ4bKu1GwSHfbnXmsM6r2FBGUJ7y25dGhjKbrG
tj9FmT02WNVaBkjeOZZx3b4MJfOSH+R6MEBvLLY2NakelVe4yd8ZZMDThfbR
Ur+PyDDn0NEiMgNUVFUlP1sDYnjcePGOxoCkLceKU+IbUKpAkP9uhgHhJ2YE
PeZNyNisXd5cngluXVseeb5pQaYUgeEhOybIFKb1Bud1o4cKLlFhBUzhn5jS
opV60JLmjVnPUiYkNY3MpyT2oOaW9Rqmb5iwQN6qWXryE2oVd3o3XM+ESGmq
qUCuF+GnG5daBpgQYBN33aqzDxlfSNXQE2WBbUWlTostEVk6pWtGH2GBSFMV
e/YKERXJeRwcPc4CGKip1PlARKV7bjKsTrLAauFf64Tdg+hZ1cfsibMsMHPo
8LLU/YoiI/3rSVdYYDQ8fv/1qm+IeeDkz9BCFqyTUhZ/1j6CLFYNdpbMsmBA
TbWzW4KMqnl/7rAUsOC+kVr6IkZGCqoWr5uXWKBwWFPz+HsykvrYZ966ig3S
OYaWKsWjaOu49qNr69nwt9oL8xYHCtJMfPtt3pwNFyvqwi31qSiJJG65HMOG
AzcJx1rtqaieH7eh/wob9E7dtnb3p6KF82+j8pLYMKjkKxOcQ0W1Bl+HTFPZ
sPeS6Mv7yhNo9WNL2a1ZbFiyciaxVyaE9wjKt6lhw/VOonUmiY6CiIKMizw2
+OZZ6xF+0FGcql5RG58NpnGFMuXKDKQ7FKK2fo4NrO2XSf+5MtBpjZXtJQts
cEnXiJhqZqC9b0OaiqQ4IH/s9EvH10zkyrNNWdbiwCM6X+Z7ChvtL7GqNnfn
QGnTmcKrL9koiaGmO/0HB5qeU2yVGtmIEXp48aUnB6aO917eIWCjFu3n01I+
HHD+VME8G8RBlMD802VBHFioCf1v1JaLxGflohJjOXDi5mRM++IkmhvNIQXm
ceD+urm5HlM+YjnbZbdPcmDd/GLfRwc+StCvUdWZ4kAmSbyi4ggfeWVbBV+e
5sDzJ8pn0yP46Nyqa/e0fwj3095NPlLOR1IW7Z7HVjjQuj2iZVhvGi2Zi5n5
K3Jh0YH/kK0ygzJ9VAMWdnMh4NKk6arZWXQ2FL/ceoELkkOx+LzIHLpIs09M
ieRC0T6ZAo78HDKYLTH8PYoLkxLb1vVum0Ne5QthnTFciHwQPJvtP4cylyyo
7xK5kFxJrTD+MoccyKlNnmnCPIdk4PP6Oxr9R6cg95Uw79uiXhU2jxLXrumv
HeLC7+faH5yMn0fqs58P6o9woTiyS1b21jw6rB/R+ZDMheDbfcsBBfPIyCqg
J4zCBep7MlWVPI/6HCNUNzC4QFL5URzjIkDyH5wzLKa50Ny5xdJW7yc6J/lj
ukdyEp6Y3vTuG1pAA6aCrpM7JsGj2ynsj3vLaNRB5/22+Emgzl1Q2iIuivX6
va86/mEScv2bPI9MiGHJIVdka79PwnTb9Y66Ogns5JXgE1n6PNgUbn7HJ0IS
Wx1uIFlxiAdul0MsjN1WY/uan6e5RvPAp+XOXiQrjaVGpU36ZfEg9PxvWgm4
DJaQHy+e/Z4HKsr2pj/b5DDXDrFcjUEePPy5P6cscS129BIh8CDOg7uazB/7
KxWwoqMnNmKSOFgH/NM2lKaILelG/PqgjsM73UcVUiFK2JtihwP223GoVnG5
3XNMGeu8cqCUiHB4vuWS4mtTFSzOQCed4oaD7JlTt7brr8PO/K25VsIPBzu9
GxqOyqpYFMfiVl0oDsESep5xU6qYfQNT71YsDvLKSdd+H12PFbpHsm7dxCHP
7qj33voN2O7r/taTD3AQ5Qftb3yshumJ2g3/+QwHatceo4lr6lj5TWlNg1c4
vO6Iq9Xx34iVGZ/fnPUGB7H5JLNFdw1sz8iMnd2/ONg4ivpN79yE4f3iUV3N
OLgo1j2/KrcZq1AfpX/oxmFQZtdA+eJmTC6M2sUcwMHNQOf1/DdNzNbnh8WW
ERz06s40/hmoha2uG1p+OoHD6mfk6pJhLYxvVLUjgyPc5/7dKz/3a2PEpq3P
Wvk4xGs+b3zQqI113sh6bDyPw9p6Lslqpw4moVU+y1rCITmTuFj1TAd7HKF/
2llsCkBGMytqHQFbcWxKI0tNAZ6WL+1yjYClnVTOGJadAocRb+reZALmfZh5
dlropwbKdfo3CdjjvM+WUnJT4NKYeHbVbQLWlTXev0vowhnf9oYHBOyXiwEx
RWg/D7VkszwCFrTbcJOZ/BT0q98V1WsiYIlGTp13107BtmCHb8rNQu8q0c0X
OqlqqVKslYB15tvHvhfa+ECIH6WDgMV83biJJvTteGd40kfAtF9E7TZXmAJH
ili80jgB01/dUkIVOseo7ojoBAH7ZCjomBd6LjrciE8jYBm152myilPwQpEy
3MMiYFoLe+TNhF6xrbdI4RMw0zqjPbeE9ky7qBQ9Q8AcKwv25ApdPmzICZoj
YNWcv3ZVC+1zMTvLXkDAbFVYWmNCVzW4h+9eIGAHfzxVmhNaWm7Nfp0lAnZP
LE9kjdIUnDreoKW4TMAKdy5yNgn97mWUYGWFgA3EFvTtEvp/RAWEpQ==
        "]]},
      Annotation[#, "Charting`Private`Tag$3211#1"]& ]}, {}}, InsetBox[
    StyleBox["\<\"0\"\>",
     StripOnInput->False,
     LineColor->GrayLevel[0],
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->12,
     FontColor->GrayLevel[0]], {-0.15, 0.02}]},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Phi]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*FractionBox[\\(\\*SubscriptBox[\\(c\\), \\(t + 1\\)] - \
\\*SubscriptBox[\\(c\\), \\(t\\)]\\), SubscriptBox[\\(c\\), \\(t\\)]]\\)\"", 
     TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[
    GrayLevel[0], 12],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 11}, {-1, 0.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{{{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}}, {{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}}},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{{3.7808292958226547`*^9, 3.7808293333597927`*^9}, 
   3.780829398141478*^9, {3.780829430178625*^9, 3.780829459967396*^9}, 
   3.7808295226532803`*^9, 3.780829599950039*^9, 3.780829648879561*^9, 
   3.780829685174951*^9, {3.780829734173799*^9, 3.780829756532093*^9}, 
   3.780829788573379*^9, 3.780829838177896*^9, {3.780829882056279*^9, 
   3.780830019766856*^9}, {3.7808300780132647`*^9, 3.780830166093234*^9}, 
   3.780830201508256*^9, {3.780830238140321*^9, 3.780830245393406*^9}, {
   3.7808302899168797`*^9, 3.780830326488562*^9}, {3.7808304176911783`*^9, 
   3.7808305069536467`*^9}, {3.780830554637497*^9, 3.780830700242247*^9}, {
   3.780830768459867*^9, 3.780830796966484*^9}, 3.78083083578581*^9, {
   3.780830900576787*^9, 3.780830915961709*^9}, {3.780830947963374*^9, 
   3.7808309650949097`*^9}, {3.780831137959797*^9, 3.780831160867778*^9}, {
   3.780831219977607*^9, 3.780831241377479*^9}, {3.780831283791304*^9, 
   3.780831297538183*^9}, 3.780831338871052*^9, 3.780831459302249*^9, 
   3.780832263629848*^9, 3.780832452085713*^9, {3.780832490004417*^9, 
   3.780832499746738*^9}, {3.780832568659827*^9, 3.780832686004456*^9}, {
   3.7811938392451468`*^9, 3.781193896566641*^9}, 3.7811939481678343`*^9, 
   3.781194027505691*^9, 3.781194062519351*^9, 3.781194122958124*^9, {
   3.7811941684419127`*^9, 3.781194261610382*^9}, {3.781194308306911*^9, 
   3.78119431693969*^9}, {3.781194366487021*^9, 3.7811943778752413`*^9}, 
   3.781194439304461*^9, {3.7811944814758043`*^9, 3.781194500477433*^9}, 
   3.781428352662785*^9, {3.781428417360319*^9, 3.781428426280423*^9}, 
   3.781428708884145*^9, {3.78142961666908*^9, 3.781429625825396*^9}, 
   3.78143003613768*^9, 3.781430308868224*^9, 3.781694233173389*^9, 
   3.781694279107621*^9, {3.781694326464769*^9, 3.781694411491084*^9}, 
   3.7816944937391453`*^9, 3.781694524010174*^9, {3.7816945579586906`*^9, 
   3.781694569897038*^9}, 3.781794752884569*^9, 3.781794907349819*^9, {
   3.781794938219749*^9, 3.781794966542045*^9}, 3.781795017777856*^9, 
   3.7817953614819107`*^9, 3.781795396027822*^9, 3.781795428476754*^9, {
   3.781795459045495*^9, 3.781795482629776*^9}, {3.7817955373108807`*^9, 
   3.781795554207593*^9}, 3.7818605730501423`*^9, {3.781860621080245*^9, 
   3.7818606458661003`*^9}, 3.854429483007524*^9, {3.854429523054132*^9, 
   3.8544295400133457`*^9}, {3.854429580156529*^9, 3.854429642785746*^9}, {
   3.854429699025343*^9, 3.854429723567956*^9}, 3.854429906422584*^9, {
   3.854429943264201*^9, 3.854429947562495*^9}},
 FontSize->24,
 CellLabel->"Out[26]=",ExpressionUUID->"7e03e183-385e-4414-854b-dc890b22b348"]
}, Open  ]]
},
WindowSize->{1280, 668},
WindowMargins->{{44, Automatic}, {Automatic, 33}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8d40de4c-32f6-4d03-a4bb-c0dabe483ab6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 382, 9, 83, "Input",ExpressionUUID->"61cb40ff-a23d-4d33-b5b3-d1c34818e87f"],
Cell[CellGroupData[{
Cell[965, 33, 7317, 156, 1221, "Input",ExpressionUUID->"1efe1ae8-7d37-4d89-953e-fb6ab9612246"],
Cell[8285, 191, 9284, 176, 409, "Output",ExpressionUUID->"7e03e183-385e-4414-854b-dc890b22b348"]
}, Open  ]]
}
]
*)

