(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    178977,       3207]
NotebookOptionsPosition[    177003,       3175]
NotebookOutlinePosition[    177401,       3191]
CellTagsIndexPosition[    177358,       3188]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.769155249292598*^9, 3.769155478823312*^9}, {
  3.7691555711283903`*^9, 3.76915559150035*^9}, {3.76915643281081*^9, 
  3.769156558536229*^9}, {3.769156675827311*^9, 3.769156676039103*^9}, {
  3.769157054313663*^9, 3.7691570571144953`*^9}, {3.7729954274886217`*^9, 
  3.772995429032259*^9}},
 FontSize->18,
 CellLabel->
  "In[572]:=",ExpressionUUID->"128e60b1-37e0-4738-bf2f-1069d9251759"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Gasteiger", " ", "and", " ", "Prettner", " ", 
    RowBox[{"(", 
     RowBox[{"2022", ",", 
      RowBox[{"p", ".233"}], ",", 
      RowBox[{"Figure", " ", "2"}]}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Last", " ", 
     RowBox[{"checked", ":", " ", 
      RowBox[{"February", " ", "21", "st"}]}]}], ",", "2022"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"IMPORTANT", ":", " ", 
    RowBox[{
    "evaluate", " ", "22", "_MD", "_gasteiger", "_prettner", "_generalized", 
     "_linearized", 
     RowBox[{"_modules", ".", "nb"}], " ", "befure", " ", "using", " ", 
     "this"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"List", " ", "of", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "=", 
     RowBox[{"1", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", 
     RowBox[{"0.98", "^", "25"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "0.009"}], ")"}], "^", "25"}], ")"}], "-", "1"}]}],
     ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"World", " ", "Bank", " ", 
        RowBox[{"(", 
         RowBox[{"2019", "a"}], ")"}]}], "\[CloseCurlyQuote]"}], "s", " ", 
      "World", " ", "Development", " ", "Indicators"}], ",", " ", 
     RowBox[{
      RowBox[{"average", " ", "over", " ", "1970"}], "-", 
      RowBox[{
      "2017", " ", "suggest", " ", "a", " ", "value", " ", "of", " ", "0.9", 
       "%"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Mu]", "=", "0.50"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1", "-", "\[Mu]"}]], " ", "=", " ", 
      RowBox[{"2", " ", "following", " ", "De", " ", "Canio", " ", 
       RowBox[{"(", 
        RowBox[{"2016", ",", "JMacro"}], ")"}], " ", "paper"}]}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{"\[Nu]", "=", "0.10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "rather", " ", "low", " ", "share", " ", "of", " ", "robots", " ", "in", 
      " ", "production"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Theta]", "=", "2.00"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"range", " ", "suggested", " ", "by", " ", "Guvenen", " ", 
      RowBox[{"(", 
       RowBox[{"2006", ",", "JME"}], ")"}], " ", "und", " ", "Chetty", " ", 
      RowBox[{"(", 
       RowBox[{"2006", ",", "AER"}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Tau]", "=", "0.00"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Transition", " ", "path"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\"\<Steady state\>\"", "\[IndentingNewLine]", 
   RowBox[{"sslist", "=", 
    RowBox[{"SteadyP", "[", 
     RowBox[{
     "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
      "\[Theta]", ",", "\[Tau]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kss", "=", 
     RowBox[{"kss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pss", "=", 
     RowBox[{"pss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wss", "=", 
     RowBox[{"wss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rss", "=", 
     RowBox[{"Rss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yss", "=", 
     RowBox[{"yss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"revss", "=", 
     RowBox[{"revss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "time", " ", "horizon", " ", "and", " ", "absolute", " ", "size", " ", 
     "of", " ", "deviation"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "16"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dev", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Convergence", " ", "from", " ", "below"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"klist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wlist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rlist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ylist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "5", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\"\<Compare \!\(\*SubscriptBox[OverscriptBox[\(p\), \(^\)], \(t\)]\) and \
\!\(\*SubscriptBox[OverscriptBox[\(k\), \(^\)], \(t\)]\)\>\"", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"plist", ",", "klist"}], "}"}], "]"}], "//", "MatrixForm"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\"\<Compute (\!\(\*FractionBox[\((\*SubscriptBox[\(p\), \(t\)] - p)\), \
\(p\)]\))*p+p=\!\(\*SubscriptBox[\(p\), \(t\)]\) and therefore \
[\!\(\*SubscriptBox[\(p\), \(t\)]\),\!\(\*SubscriptBox[\(k\), \
\(t\)]\),\!\(\*SubscriptBox[\(w\), \(t\)]\),\!\(\*SubscriptBox[\(R\), \
\(t\)]\)/100]\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plevel", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"plist", "*", "pss"}], "+", "pss"}], ")"}], "*", "100"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"klevel", "=", 
     RowBox[{
      RowBox[{"klist", "*", "kss"}], "+", "kss"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wlevel", "=", 
     RowBox[{
      RowBox[{"wlist", "*", "wss"}], "+", "wss"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rlevel", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Rlist", "*", "Rss"}], "+", "Rss"}], ")"}], "/", "100"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ylevel", "=", 
     RowBox[{
      RowBox[{"ylist", "*", "yss"}], "+", "yss"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"revlevel", "=", 
     RowBox[{"\[Tau]", "*", "Rlevel", "*", "plevel", "*", "1000"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
      "plevel", ",", "klevel", ",", "wlevel", ",", "Rlevel", ",", "ylevel", 
       ",", "revlevel"}], "}"}], "]"}], "//", "MatrixForm"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["p", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"padding", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"plevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"pss", "*", "100"}], ",", "tmax"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "klevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(p\), \(t\)]\)*100\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.025", ",", "0.05", ",", "0.075", ",", "0.1"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_p.pdf\>\"", ",", 
      "pplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["k", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"kplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"klevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"kss", ",", "tmax"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "klevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(k\), \(t\)]\)\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.025", ",", "0.05", ",", "0.075", ",", "0.1"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_k.pdf\>\"", ",", 
      "kplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["w", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"wplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"wlevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"wss", ",", "tmax"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "wlevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(w\), \(t\)]\)\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.1", ",", "0.2"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_w.pdf\>\"", ",", 
      "wplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["R", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Rplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Rlevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"Rss", "/", "100"}], ",", "tmax"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "Rlevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(R\), \(t\)]\)/100\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.01", ",", "0.02", ",", "0.03"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_R.pdf\>\"", ",", 
      "Rplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["w", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"yplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"ylevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"yss", ",", "tmax"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "ylevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(y\), \(t\)]\)\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.1", ",", "0.2", ",", "0.3"}], "}"}]}], "}"}]}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_y.pdf\>\"", ",", 
      "yplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", "\[Tau]", "*", 
     SubscriptBox["R", "t"], "*", 
     SubscriptBox["p", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"revplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"revlevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"revss", "*", "1000"}], ",", "tmax"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"0.07513912573171849", "*", "1.05"}]}], "}"}]}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", 
         "\"\<\[Tau]*\!\(\*SubscriptBox[\(R\), \
\(t\)]\)*\!\(\*SubscriptBox[\(p\), \(t\)]\)*1000\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.05", ",", "0.10"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Combine", " ", "plots"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Levelplot2", "=", 
    RowBox[{"GraphicsGrid", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"pplot", ",", "kplot"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"wplot", ",", "Rplot"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "yplot", "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Right", ",", "Center"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels.pdf\>\"", ",", 
      "Levelplot2"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Tau]", ",", "n", ",", "\[Mu]", ",", 
     "\[Nu]", ",", "\[Theta]", ",", "kss", ",", "pss", ",", "wss", ",", 
     "sslist", ",", "Rss", ",", "yss", ",", "tmax", ",", "dev", ",", "plist", 
     ",", "klist", ",", "wlist", ",", "Rlist", ",", "ylist", ",", "plevel", 
     ",", "klevel", ",", "wlevel", ",", "Rlevel", ",", "ylevel", ",", 
     "revlevel", ",", "pplot", ",", "kplot", ",", "wplot", ",", "Rplot", ",", 
     "yplot", ",", "revplot", ",", "padding", ",", "Levelplot2"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7733917668802137`*^9, 3.77339179273109*^9}, {
   3.773391829842263*^9, 3.773391978403718*^9}, {3.7733921759468927`*^9, 
   3.773392209641366*^9}, {3.773392310789617*^9, 3.773392313836546*^9}, {
   3.773392360474341*^9, 3.773392419223817*^9}, {3.773392452176407*^9, 
   3.773392464261669*^9}, {3.773392547370617*^9, 3.7733925522013903`*^9}, {
   3.773392601073112*^9, 3.773392680091463*^9}, {3.773392768457448*^9, 
   3.773392779847052*^9}, {3.773392983271264*^9, 3.773393155558972*^9}, {
   3.7733931860392103`*^9, 3.773393205430887*^9}, {3.773393263491508*^9, 
   3.773393446818468*^9}, {3.773393498217054*^9, 3.7733936063003597`*^9}, {
   3.7733936520680017`*^9, 3.7733937653727694`*^9}, {3.77339385709011*^9, 
   3.773393859792488*^9}, {3.77339394803855*^9, 3.773394010746344*^9}, {
   3.773398241575759*^9, 3.773398332402384*^9}, {3.773398375746552*^9, 
   3.773398426743781*^9}, {3.773398470871355*^9, 3.773398485542302*^9}, {
   3.773398519212822*^9, 3.7733985215720787`*^9}, {3.773398554011334*^9, 
   3.773398572049038*^9}, {3.773398603041649*^9, 3.7733986881630507`*^9}, {
   3.7733987369551764`*^9, 3.77339874198531*^9}, {3.7733987813859873`*^9, 
   3.77339880393635*^9}, 3.773398849326689*^9, {3.773398924267037*^9, 
   3.7733992397492867`*^9}, {3.773399291451158*^9, 3.773399358871901*^9}, {
   3.773399426436108*^9, 3.7733994722279797`*^9}, {3.773399535199213*^9, 
   3.7733995961320868`*^9}, {3.773399771542903*^9, 3.773399811083898*^9}, 
   3.773399902713722*^9, {3.773399938751418*^9, 3.773399964484964*^9}, {
   3.7734246189210663`*^9, 3.773424678396941*^9}, {3.773426606999332*^9, 
   3.773426641874914*^9}, {3.773426704212275*^9, 3.773426709993022*^9}, {
   3.7734268528226137`*^9, 3.77342688205868*^9}, {3.773426935701449*^9, 
   3.773426937522723*^9}, {3.77342710006528*^9, 3.7734271381403923`*^9}, 
   3.773427170988928*^9, {3.773427243169565*^9, 3.773427243244726*^9}, {
   3.774029579642405*^9, 3.7740296304919662`*^9}, {3.7740297219179907`*^9, 
   3.774029763421412*^9}, {3.774029800578065*^9, 3.774029810172364*^9}, {
   3.774029950738675*^9, 3.77403000747432*^9}, {3.774030116597883*^9, 
   3.7740301411628933`*^9}, {3.774030176276206*^9, 3.774030212768416*^9}, {
   3.774030280665854*^9, 3.7740303093474903`*^9}, {3.774073708843416*^9, 
   3.7740737476970882`*^9}, {3.774084671571754*^9, 3.7740846794229097`*^9}, {
   3.774084750854319*^9, 3.774084751019547*^9}, {3.77408483897779*^9, 
   3.77408484056819*^9}, {3.774084886798933*^9, 3.7740848946214*^9}, 
   3.774084932078457*^9, {3.774085043169739*^9, 3.774085045783342*^9}, 
   3.774085091729251*^9, {3.774085121918262*^9, 3.774085137220755*^9}, {
   3.774085194292819*^9, 3.774085196200794*^9}, {3.774178297912943*^9, 
   3.774178369796216*^9}, {3.774178458472351*^9, 3.774178526437737*^9}, {
   3.774180896717987*^9, 3.7741809094044123`*^9}, {3.774180986377933*^9, 
   3.774180991239732*^9}, {3.774181031854864*^9, 3.7741811567761097`*^9}, {
   3.774181231477806*^9, 3.774181246883071*^9}, {3.774181350272564*^9, 
   3.7741814442657633`*^9}, {3.774181479370158*^9, 3.774181495592381*^9}, {
   3.774181527766824*^9, 3.774181539558145*^9}, {3.774181620318185*^9, 
   3.7741816206675987`*^9}, {3.7741816551480627`*^9, 
   3.7741816840108423`*^9}, {3.7741817550143967`*^9, 
   3.7741817577091084`*^9}, {3.774181967648059*^9, 3.774181969316431*^9}, {
   3.774182155541313*^9, 3.774182156276134*^9}, {3.7741822149230137`*^9, 
   3.774182218464904*^9}, {3.774182342305931*^9, 3.7741823786731987`*^9}, {
   3.774230685007359*^9, 3.7742309168032923`*^9}, {3.774230964735941*^9, 
   3.774230968834917*^9}, {3.774231015924121*^9, 3.7742310815871897`*^9}, {
   3.7742311558183823`*^9, 3.7742311590792713`*^9}, 3.77423122401649*^9, {
   3.7742313060132523`*^9, 3.774231310459304*^9}, {3.77423134277321*^9, 
   3.774231360849763*^9}, {3.774231417404829*^9, 3.7742314356615458`*^9}, 
   3.774231644577116*^9, {3.774231863628902*^9, 3.77423186947793*^9}, {
   3.774231929125705*^9, 3.7742319389189863`*^9}, {3.774232057086616*^9, 
   3.7742320753745832`*^9}, {3.77423211706817*^9, 3.7742321193892117`*^9}, {
   3.7742321570764513`*^9, 3.7742321632799892`*^9}, 3.774232208836399*^9, {
   3.774232248829008*^9, 3.774232264924375*^9}, {3.774232314092317*^9, 
   3.7742323216834917`*^9}, {3.7742323630399218`*^9, 3.774232401209587*^9}, {
   3.774232482536457*^9, 3.774232606123908*^9}, {3.774232658873457*^9, 
   3.77423267290432*^9}, {3.774232756715013*^9, 3.774232819200328*^9}, {
   3.774237915953712*^9, 3.7742380103045883`*^9}, 3.774238100274572*^9, {
   3.774238144320325*^9, 3.7742381639666147`*^9}, {3.7742382015044117`*^9, 
   3.7742382051881943`*^9}, {3.774238465149507*^9, 3.774238493068646*^9}, {
   3.7742385654290237`*^9, 3.77423856606706*^9}, {3.774238598700519*^9, 
   3.7742386055158663`*^9}, {3.774242842070105*^9, 3.774242862113349*^9}, {
   3.7742429791435633`*^9, 3.774242979868896*^9}, {3.774243040716538*^9, 
   3.774243071272138*^9}, {3.774243170862297*^9, 3.774243229279975*^9}, {
   3.774243289513026*^9, 3.774243293469123*^9}, {3.774243331245906*^9, 
   3.7742433363875723`*^9}, {3.774243373723495*^9, 3.774243376226061*^9}, {
   3.77424342715322*^9, 3.774243446190815*^9}, {3.774243481399125*^9, 
   3.774243520784573*^9}, {3.774243573176964*^9, 3.774243574150716*^9}, 
   3.7742438013593597`*^9, {3.774243834188552*^9, 3.7742438391560097`*^9}, {
   3.774243899332137*^9, 3.774243923030896*^9}, {3.774244069666292*^9, 
   3.774244092023683*^9}, {3.774244143590818*^9, 3.774244144196745*^9}, {
   3.774244355221249*^9, 3.7742443573641663`*^9}, {3.774247358528124*^9, 
   3.774247358710548*^9}, 3.7742474290783653`*^9, 3.774251148025975*^9, 
   3.7742513512033367`*^9, {3.7742526775297194`*^9, 3.7742526779519167`*^9}, 
   3.774253493852786*^9, {3.7742688435877237`*^9, 3.774268900401936*^9}, {
   3.774348548642095*^9, 3.774348563023197*^9}, {3.774348653102703*^9, 
   3.7743486536275473`*^9}, {3.774348683804538*^9, 3.774348710165668*^9}, {
   3.774348823059702*^9, 3.7743488765993147`*^9}, {3.7743489243102217`*^9, 
   3.774348960356777*^9}, {3.774348990783209*^9, 3.774349033546344*^9}, {
   3.77434906995259*^9, 3.774349104519968*^9}, {3.774606478370194*^9, 
   3.774606521589222*^9}, 3.774606568035166*^9, 3.7746066922719*^9, {
   3.7746067377395678`*^9, 3.7746067502983294`*^9}, {3.774606946308014*^9, 
   3.7746069524819183`*^9}, {3.774607239983203*^9, 3.774607261733411*^9}, {
   3.7746072948270597`*^9, 3.774607306195703*^9}, {3.774607391514312*^9, 
   3.774607562327792*^9}, {3.774607960905622*^9, 3.774608088545203*^9}, {
   3.774608334551139*^9, 3.774608414348881*^9}, {3.774608447267157*^9, 
   3.774608694468364*^9}, 3.774608813712681*^9, 3.7746089154325953`*^9, {
   3.7746089860299*^9, 3.774609009921699*^9}, {3.774609154550202*^9, 
   3.774609212979765*^9}, {3.774689592592545*^9, 3.774689592782811*^9}, {
   3.774689681387068*^9, 3.774689684643175*^9}, {3.774689750550521*^9, 
   3.7746898687387238`*^9}, {3.7746899199438953`*^9, 3.774689923678752*^9}, {
   3.77469008057791*^9, 3.7746900850472603`*^9}, {3.774690152198559*^9, 
   3.7746901534131603`*^9}, 3.774690312610609*^9, {3.774690399778759*^9, 
   3.774690405976438*^9}, {3.7788268793200607`*^9, 3.778826921318365*^9}, {
   3.7788269650117283`*^9, 3.778826969245*^9}, {3.778827001763763*^9, 
   3.7788270348008223`*^9}, {3.778827071749048*^9, 3.778827079882613*^9}, {
   3.7789035522774143`*^9, 3.778903552388523*^9}, {3.780804856996805*^9, 
   3.780804857353479*^9}, {3.78169598217179*^9, 3.781695982323139*^9}, {
   3.7816961401463633`*^9, 3.781696168806058*^9}, {3.7816962483500357`*^9, 
   3.781696296793517*^9}, {3.781858424122633*^9, 3.781858452128716*^9}, {
   3.781858490049098*^9, 3.781858506470388*^9}, {3.7818586693059587`*^9, 
   3.7818586820621653`*^9}, {3.7818588452801867`*^9, 3.781858872303433*^9}, {
   3.7818589291893787`*^9, 3.7818589535632353`*^9}, {3.781858999722123*^9, 
   3.781859061055868*^9}, {3.781859094037561*^9, 3.78185909553231*^9}, {
   3.781859127405629*^9, 3.781859142106032*^9}, {3.781859218046562*^9, 
   3.78185924844271*^9}, 3.7818592887410583`*^9, {3.78185932085215*^9, 
   3.781859354670979*^9}, {3.7818594592541847`*^9, 3.781859512671524*^9}, {
   3.781859545777259*^9, 3.781859576759906*^9}, {3.854430023101767*^9, 
   3.854430039636586*^9}, {3.8544302361467752`*^9, 3.854430240546682*^9}, {
   3.8544302803376226`*^9, 3.854430313879422*^9}, {3.85443037233393*^9, 
   3.8544303730054893`*^9}, {3.8544305634625263`*^9, 3.854430565307719*^9}, {
   3.854430599950989*^9, 3.8544306720602083`*^9}, {3.854430724111477*^9, 
   3.854430739195857*^9}, {3.854430779723824*^9, 3.8544308286932077`*^9}, {
   3.854430955209877*^9, 3.85443098259235*^9}, {3.854431319821809*^9, 
   3.854431336580917*^9}, {3.8544315757129927`*^9, 3.854431576230384*^9}, {
   3.854432989890485*^9, 
   3.8544330260166807`*^9}},ExpressionUUID->"4ca19a78-2b0f-451e-948e-\
1e1529dbd2a6"],

Cell[BoxData["\<\"Implied elasticity \\!\\(\\*FractionBox[\\(1\\), \\(1 - \
\[Mu]\\)]\\) =\"\>"], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.85443085176309*^9},
 CellLabel->
  "Out[529]=",ExpressionUUID->"9d5fbe0b-4f6b-4215-bf84-e9152205be29"],

Cell[BoxData["2.`"], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.8544308517651997`*^9},
 CellLabel->
  "Out[530]=",ExpressionUUID->"b241708d-463d-4dca-81f0-478d4ef4d4d2"],

Cell[BoxData["\<\"Steady state\"\>"], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430851766551*^9},
 CellLabel->
  "Out[532]=",ExpressionUUID->"5b3ac3c8-f336-49d0-8d34-abb9b71e33f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"kss", "\[Rule]", "0.0720174143522766`"}], ",", 
   RowBox[{"pss", "\[Rule]", "0.0002552169968249995`"}], ",", 
   RowBox[{"wss", "\[Rule]", "0.24115781102495687`"}], ",", 
   RowBox[{"Rss", "\[Rule]", "1.6772740457470197`"}], ",", 
   RowBox[{"yss", "\[Rule]", "0.3623788198046475`"}], ",", 
   RowBox[{"0.`", "\[Rule]", "0.`"}], ",", 
   RowBox[{"c1ss", "\[Rule]", "0.15074020106249075`"}], ",", 
   RowBox[{"c2ss", "\[Rule]", "0.1516551104685216`"}], ",", 
   RowBox[{"savess", "\[Rule]", "0.09041760996246613`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430851767918*^9},
 CellLabel->
  "Out[533]=",ExpressionUUID->"82d23af4-abf6-408b-9efd-6510164d6205"],

Cell[BoxData["\<\"Compare \\!\\(\\*SubscriptBox[OverscriptBox[\\(p\\), \
\\(^\\)], \\(t\\)]\\) and \\!\\(\\*SubscriptBox[OverscriptBox[\\(k\\), \
\\(^\\)], \\(t\\)]\\)\"\>"], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.8544308517887497`*^9},
 CellLabel->
  "Out[547]=",ExpressionUUID->"346da1b8-c63b-44ee-9fb1-243c766984b4"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1.`"}], 
      RowBox[{"-", "0.9999999999999967`"}]},
     {
      RowBox[{"-", "0.42124140845671026`"}], 
      RowBox[{"-", "0.4212414084567089`"}]},
     {
      RowBox[{"-", "0.17744432419859302`"}], 
      RowBox[{"-", "0.17744432419859243`"}]},
     {
      RowBox[{"-", "0.07474689704806443`"}], 
      RowBox[{"-", "0.07474689704806418`"}]},
     {
      RowBox[{"-", "0.031486488190295384`"}], 
      RowBox[{"-", "0.03148648819029528`"}]},
     {
      RowBox[{"-", "0.013263412632635602`"}], 
      RowBox[{"-", "0.013263412632635559`"}]},
     {
      RowBox[{"-", "0.005587098618313945`"}], 
      RowBox[{"-", "0.0055870986183139265`"}]},
     {
      RowBox[{"-", "0.0023535172911651058`"}], 
      RowBox[{"-", "0.002353517291165098`"}]},
     {
      RowBox[{"-", "0.0009913989385576106`"}], 
      RowBox[{"-", "0.0009913989385576074`"}]},
     {
      RowBox[{"-", "0.00041761828522049547`"}], 
      RowBox[{"-", "0.0004176182852204941`"}]},
     {
      RowBox[{"-", "0.00017591811466355765`"}], 
      RowBox[{"-", "0.00017591811466355708`"}]},
     {
      RowBox[{"-", "0.00007410399439392608`"}], 
      RowBox[{"-", "0.00007410399439392584`"}]},
     {
      RowBox[{"-", "0.00003121567097076558`"}], 
      RowBox[{"-", "0.00003121567097076547`"}]},
     {
      RowBox[{"-", "0.000013149333205646537`"}], 
      RowBox[{"-", "0.000013149333205646492`"}]},
     {
      RowBox[{"-", "5.539043639813136`*^-6"}], 
      RowBox[{"-", "5.539043639813118`*^-6"}]},
     {
      RowBox[{"-", "2.3332745443380684`*^-6"}], 
      RowBox[{"-", "2.3332745443380607`*^-6"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.8544308517906647`*^9},
 CellLabel->
  "Out[548]//MatrixForm=",ExpressionUUID->"58b6eaaf-fe2e-4e19-a1ec-\
8f527d779722"],

Cell[BoxData["\<\"Compute (\\!\\(\\*FractionBox[\\((\\*SubscriptBox[\\(p\\), \
\\(t\\)] - p)\\), \\(p\\)]\\))*p+p=\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\) \
and therefore [\\!\\(\\*SubscriptBox[\\(p\\), \
\\(t\\)]\\),\\!\\(\\*SubscriptBox[\\(k\\), \\(t\\)]\\),\\!\\(\\*SubscriptBox[\
\\(w\\), \\(t\\)]\\),\\!\\(\\*SubscriptBox[\\(R\\), \\(t\\)]\\)/100]\"\>"], \
"Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430851792145*^9},
 CellLabel->
  "Out[549]=",ExpressionUUID->"e078eafc-d581-4e54-b64f-9c9fbc5e2b6a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.`", "2.3592239273284576`*^-16", "0.16070065562586858`", 
      "0.027934754219184416`", "0.2411578110249573`", "0.`"},
     {"0.014770902962034496`", "0.041680697297113205`", 
      "0.20726592556422452`", "0.02147464285566788`", "0.31131551133174756`", 
      "0.`"},
     {"0.020993018929939298`", "0.059238332932006865`", 
      "0.22688114545822446`", "0.01875337644611297`", "0.34086883982306365`", 
      "0.`"},
     {"0.023614031823840507`", "0.0666343360960192`", "0.2351438883135611`", 
      "0.01760706635096613`", "0.35331792554132946`", "0.`"},
     {"0.02471811098685065`", "0.06974983888577804`", "0.23862449775165873`", 
      "0.017124193071958328`", "0.3585619959432901`", "0.`"},
     {"0.02518319484852475`", "0.07106221766898686`", "0.2400906745736507`", 
      "0.01692078685180297`", "0.3607710155454581`", "0.`"},
     {"0.02537910742946683`", "0.07161504595605445`", "0.24070828896319316`", 
      "0.016835103729135874`", "0.36170154607398386`", "0.`"},
     {"0.025461633920997265`", "0.07184792012233351`", "0.24096845371852715`",
       "0.016799010449862616`", "0.362093524064432`", "0.`"},
     {"0.025496397496524534`", "0.07194601636413009`", "0.24107804588649484`",
       "0.016783806466065726`", "0.3622586414252124`", "0.`"},
     {"0.02551104135404263`", "0.07198733856318879`", "0.24112421064568537`", 
      "0.01677740191851697`", "0.3623281956948282`", "0.`"},
     {"0.025517209953208792`", "0.0720047451845208`", "0.24114365715386787`", 
      "0.016774704057887006`", "0.36235749483332536`", "0.`"},
     {"0.025519808422609754`", "0.07201207757420718`", "0.2411518488283642`", 
      "0.01677356760727542`", "0.36236983684369245`", "0.`"},
     {"0.025520903005520047`", "0.07201516628036601`", "0.2411552995008667`", 
      "0.016773088887219154`", "0.3623750358095227`", "0.`"},
     {"0.025521364089166852`", "0.07201646737129867`", "0.24115675306701176`",
       "0.016772887230508397`", "0.3623772258292115`", "0.`"},
     {"0.02552155831669165`", "0.07201701544467567`", "0.24115736536926197`", 
      "0.016772802284351532`", "0.3623781483561898`", "0.`"},
     {"0.02552164013336775`", "0.07201724631587694`", "0.24115762329632426`", 
      "0.01677276650151277`", "0.36237853696275346`", "0.`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430851793971*^9},
 CellLabel->
  "Out[556]//MatrixForm=",ExpressionUUID->"549da4d1-4365-498d-9e46-\
ccb4da1fbe11"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.}, {1.0666666666666667`, 0.014770902962034496`}, {
      2.1333333333333333`, 0.020993018929939298`}, {3.2, 
      0.023614031823840507`}, {4.266666666666667, 0.02471811098685065}, {
      5.333333333333333, 0.02518319484852475}, {6.4, 0.02537910742946683}, {
      7.466666666666667, 0.025461633920997265`}, {8.533333333333333, 
      0.025496397496524534`}, {9.6, 0.02551104135404263}, {
      10.666666666666666`, 0.025517209953208792`}, {11.733333333333333`, 
      0.025519808422609754`}, {12.8, 0.025520903005520047`}, {
      13.866666666666667`, 0.025521364089166852`}, {14.933333333333334`, 
      0.02552155831669165}, {16., 0.02552164013336775}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.02552169968249995}, {1.0666666666666667`, 
      0.02552169968249995}, {2.1333333333333333`, 0.02552169968249995}, {3.2, 
      0.02552169968249995}, {4.266666666666667, 0.02552169968249995}, {
      5.333333333333333, 0.02552169968249995}, {6.4, 0.02552169968249995}, {
      7.466666666666667, 0.02552169968249995}, {8.533333333333333, 
      0.02552169968249995}, {9.6, 0.02552169968249995}, {10.666666666666666`, 
      0.02552169968249995}, {11.733333333333333`, 0.02552169968249995}, {12.8,
       0.02552169968249995}, {13.866666666666667`, 0.02552169968249995}, {
      14.933333333333334`, 0.02552169968249995}, {16., 
      0.02552169968249995}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*100\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.07561810863167079}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.025, 
      FormBox["0.025`", TraditionalForm]}, {0.05, 
      FormBox["0.05`", TraditionalForm]}, {0.075, 
      FormBox["0.075`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430851818474*^9},
 CellLabel->
  "Out[558]=",ExpressionUUID->"b5d6473e-618e-45d5-b698-3ec5fbeb0135"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 2.3592239273284576`*^-16}, {1.0666666666666667`, 
      0.041680697297113205`}, {2.1333333333333333`, 0.059238332932006865`}, {
      3.2, 0.0666343360960192}, {4.266666666666667, 0.06974983888577804}, {
      5.333333333333333, 0.07106221766898686}, {6.4, 0.07161504595605445}, {
      7.466666666666667, 0.07184792012233351}, {8.533333333333333, 
      0.07194601636413009}, {9.6, 0.07198733856318879}, {10.666666666666666`, 
      0.0720047451845208}, {11.733333333333333`, 0.07201207757420718}, {12.8, 
      0.07201516628036601}, {13.866666666666667`, 0.07201646737129867}, {
      14.933333333333334`, 0.07201701544467567}, {16., 
      0.07201724631587694}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.0720174143522766}, {1.0666666666666667`, 
      0.0720174143522766}, {2.1333333333333333`, 0.0720174143522766}, {3.2, 
      0.0720174143522766}, {4.266666666666667, 0.0720174143522766}, {
      5.333333333333333, 0.0720174143522766}, {6.4, 0.0720174143522766}, {
      7.466666666666667, 0.0720174143522766}, {8.533333333333333, 
      0.0720174143522766}, {9.6, 0.0720174143522766}, {10.666666666666666`, 
      0.0720174143522766}, {11.733333333333333`, 0.0720174143522766}, {12.8, 
      0.0720174143522766}, {13.866666666666667`, 0.0720174143522766}, {
      14.933333333333334`, 0.0720174143522766}, {16., 
      0.0720174143522766}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(t\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.07561810863167079}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.025, 
      FormBox["0.025`", TraditionalForm]}, {0.05, 
      FormBox["0.05`", TraditionalForm]}, {0.075, 
      FormBox["0.075`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430851994369*^9},
 CellLabel->
  "Out[560]=",ExpressionUUID->"6962f18a-3880-46cf-bff8-813b5ca04a4e"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.16070065562586858`}, {1.0666666666666667`, 
      0.20726592556422452`}, {2.1333333333333333`, 0.22688114545822446`}, {
      3.2, 0.2351438883135611}, {4.266666666666667, 0.23862449775165873`}, {
      5.333333333333333, 0.2400906745736507}, {6.4, 0.24070828896319316`}, {
      7.466666666666667, 0.24096845371852715`}, {8.533333333333333, 
      0.24107804588649484`}, {9.6, 0.24112421064568537`}, {
      10.666666666666666`, 0.24114365715386787`}, {11.733333333333333`, 
      0.2411518488283642}, {12.8, 0.2411552995008667}, {13.866666666666667`, 
      0.24115675306701176`}, {14.933333333333334`, 0.24115736536926197`}, {
      16., 0.24115762329632426`}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.24115781102495687`}, {1.0666666666666667`, 
      0.24115781102495687`}, {2.1333333333333333`, 0.24115781102495687`}, {
      3.2, 0.24115781102495687`}, {4.266666666666667, 0.24115781102495687`}, {
      5.333333333333333, 0.24115781102495687`}, {6.4, 0.24115781102495687`}, {
      7.466666666666667, 0.24115781102495687`}, {8.533333333333333, 
      0.24115781102495687`}, {9.6, 0.24115781102495687`}, {
      10.666666666666666`, 0.24115781102495687`}, {11.733333333333333`, 
      0.24115781102495687`}, {12.8, 0.24115781102495687`}, {
      13.866666666666667`, 0.24115781102495687`}, {14.933333333333334`, 
      0.24115781102495687`}, {16., 0.24115781102495687`}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(t\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.2532155044611405}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.8544308521682*^9},
 CellLabel->
  "Out[562]=",ExpressionUUID->"9dc5d52c-3994-4b27-ba15-fbebc3f24ab5"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.027934754219184416`}, {1.0666666666666667`, 
      0.02147464285566788}, {2.1333333333333333`, 0.01875337644611297}, {3.2, 
      0.01760706635096613}, {4.266666666666667, 0.017124193071958328`}, {
      5.333333333333333, 0.01692078685180297}, {6.4, 0.016835103729135874`}, {
      7.466666666666667, 0.016799010449862616`}, {8.533333333333333, 
      0.016783806466065726`}, {9.6, 0.01677740191851697}, {
      10.666666666666666`, 0.016774704057887006`}, {11.733333333333333`, 
      0.01677356760727542}, {12.8, 0.016773088887219154`}, {
      13.866666666666667`, 0.016772887230508397`}, {14.933333333333334`, 
      0.016772802284351532`}, {16., 0.01677276650151277}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.0167727404574702}, {1.0666666666666667`, 
      0.0167727404574702}, {2.1333333333333333`, 0.0167727404574702}, {3.2, 
      0.0167727404574702}, {4.266666666666667, 0.0167727404574702}, {
      5.333333333333333, 0.0167727404574702}, {6.4, 0.0167727404574702}, {
      7.466666666666667, 0.0167727404574702}, {8.533333333333333, 
      0.0167727404574702}, {9.6, 0.0167727404574702}, {10.666666666666666`, 
      0.0167727404574702}, {11.733333333333333`, 0.0167727404574702}, {12.8, 
      0.0167727404574702}, {13.866666666666667`, 0.0167727404574702}, {
      14.933333333333334`, 0.0167727404574702}, {16., 
      0.0167727404574702}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(R\\), \\(t\\)]\\)/100\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.029331491930143637`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.01, 
      FormBox["0.01`", TraditionalForm]}, {0.02, 
      FormBox["0.02`", TraditionalForm]}, {0.03, 
      FormBox["0.03`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430852339654*^9},
 CellLabel->
  "Out[564]=",ExpressionUUID->"110afef5-3ba9-4d02-a126-1ac7b3fef311"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.2411578110249573}, {1.0666666666666667`, 
      0.31131551133174756`}, {2.1333333333333333`, 0.34086883982306365`}, {
      3.2, 0.35331792554132946`}, {4.266666666666667, 0.3585619959432901}, {
      5.333333333333333, 0.3607710155454581}, {6.4, 0.36170154607398386`}, {
      7.466666666666667, 0.362093524064432}, {8.533333333333333, 
      0.3622586414252124}, {9.6, 0.3623281956948282}, {10.666666666666666`, 
      0.36235749483332536`}, {11.733333333333333`, 0.36236983684369245`}, {
      12.8, 0.3623750358095227}, {13.866666666666667`, 0.3623772258292115}, {
      14.933333333333334`, 0.3623781483561898}, {16., 
      0.36237853696275346`}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.3623788198046475}, {1.0666666666666667`, 
      0.3623788198046475}, {2.1333333333333333`, 0.3623788198046475}, {3.2, 
      0.3623788198046475}, {4.266666666666667, 0.3623788198046475}, {
      5.333333333333333, 0.3623788198046475}, {6.4, 0.3623788198046475}, {
      7.466666666666667, 0.3623788198046475}, {8.533333333333333, 
      0.3623788198046475}, {9.6, 0.3623788198046475}, {10.666666666666666`, 
      0.3623788198046475}, {11.733333333333333`, 0.3623788198046475}, {12.8, 
      0.3623788198046475}, {13.866666666666667`, 0.3623788198046475}, {
      14.933333333333334`, 0.3623788198046475}, {16., 
      0.3623788198046475}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(y\\), \\(t\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.38049746381089117`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.3, 
      FormBox["0.3`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.85443085251023*^9},
 CellLabel->
  "Out[566]=",ExpressionUUID->"1abd650e-6773-4436-a758-6b31c020f349"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.}, {1.0666666666666667`, 0.}, {2.1333333333333333`, 
      0.}, {3.2, 0.}, {4.266666666666667, 0.}, {5.333333333333333, 0.}, {6.4, 
      0.}, {7.466666666666667, 0.}, {8.533333333333333, 0.}, {9.6, 0.}, {
      10.666666666666666`, 0.}, {11.733333333333333`, 0.}, {12.8, 0.}, {
      13.866666666666667`, 0.}, {14.933333333333334`, 0.}, {16., 0.}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.}, {1.0666666666666667`, 0.}, {2.1333333333333333`, 
      0.}, {3.2, 0.}, {4.266666666666667, 0.}, {5.333333333333333, 0.}, {6.4, 
      0.}, {7.466666666666667, 0.}, {8.533333333333333, 0.}, {9.6, 0.}, {
      10.666666666666666`, 0.}, {11.733333333333333`, 0.}, {12.8, 0.}, {
      13.866666666666667`, 0.}, {14.933333333333334`, 0.}, {16., 
      0.}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\[Tau]*\\!\\(\\*SubscriptBox[\\(R\\), \
\\(t\\)]\\)*\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*1000\"", 
     TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.07889608201830442}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.05, 
      FormBox["0.05`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.854430852677371*^9},
 CellLabel->
  "Out[568]=",ExpressionUUID->"f7013a4d-0b90-478f-970c-3fc407ee1fed"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.}, {1.0666666666666667`, 0.014770902962034496`}, {
           2.1333333333333333`, 0.020993018929939298`}, {3.2, 
           0.023614031823840507`}, {4.266666666666667, 0.02471811098685065}, {
           5.333333333333333, 0.02518319484852475}, {6.4, 
           0.02537910742946683}, {7.466666666666667, 0.025461633920997265`}, {
           8.533333333333333, 0.025496397496524534`}, {9.6, 
           0.02551104135404263}, {10.666666666666666`, 
           0.025517209953208792`}, {11.733333333333333`, 
           0.025519808422609754`}, {12.8, 0.025520903005520047`}, {
           13.866666666666667`, 0.025521364089166852`}, {14.933333333333334`, 
           0.02552155831669165}, {16., 0.02552164013336775}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.02552169968249995}, {1.0666666666666667`, 
           0.02552169968249995}, {2.1333333333333333`, 0.02552169968249995}, {
           3.2, 0.02552169968249995}, {4.266666666666667, 
           0.02552169968249995}, {5.333333333333333, 0.02552169968249995}, {
           6.4, 0.02552169968249995}, {7.466666666666667, 
           0.02552169968249995}, {8.533333333333333, 0.02552169968249995}, {
           9.6, 0.02552169968249995}, {10.666666666666666`, 
           0.02552169968249995}, {11.733333333333333`, 0.02552169968249995}, {
           12.8, 0.02552169968249995}, {13.866666666666667`, 
           0.02552169968249995}, {14.933333333333334`, 0.02552169968249995}, {
           16., 0.02552169968249995}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*100\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30, 30}, {30, 30}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.07561810863167079}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.025, 
           FormBox["0.025`", TraditionalForm]}, {0.05, 
           FormBox["0.05`", TraditionalForm]}, {0.075, 
           FormBox["0.075`", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}}}], {372., -193.5}, 
      ImageScaled[{1, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 2.3592239273284576`*^-16}, {1.0666666666666667`, 
           0.041680697297113205`}, {2.1333333333333333`, 
           0.059238332932006865`}, {3.2, 0.0666343360960192}, {
           4.266666666666667, 0.06974983888577804}, {5.333333333333333, 
           0.07106221766898686}, {6.4, 0.07161504595605445}, {
           7.466666666666667, 0.07184792012233351}, {8.533333333333333, 
           0.07194601636413009}, {9.6, 0.07198733856318879}, {
           10.666666666666666`, 0.0720047451845208}, {11.733333333333333`, 
           0.07201207757420718}, {12.8, 0.07201516628036601}, {
           13.866666666666667`, 0.07201646737129867}, {14.933333333333334`, 
           0.07201701544467567}, {16., 0.07201724631587694}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.0720174143522766}, {1.0666666666666667`, 
           0.0720174143522766}, {2.1333333333333333`, 0.0720174143522766}, {
           3.2, 0.0720174143522766}, {4.266666666666667, 
           0.0720174143522766}, {5.333333333333333, 0.0720174143522766}, {6.4,
            0.0720174143522766}, {7.466666666666667, 0.0720174143522766}, {
           8.533333333333333, 0.0720174143522766}, {9.6, 
           0.0720174143522766}, {10.666666666666666`, 0.0720174143522766}, {
           11.733333333333333`, 0.0720174143522766}, {12.8, 
           0.0720174143522766}, {13.866666666666667`, 0.0720174143522766}, {
           14.933333333333334`, 0.0720174143522766}, {16., 
           0.0720174143522766}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(t\\)]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30, 30}, {30, 30}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.07561810863167079}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.025, 
           FormBox["0.025`", TraditionalForm]}, {0.05, 
           FormBox["0.05`", TraditionalForm]}, {0.075, 
           FormBox["0.075`", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}}}], {756., -193.5}, 
      ImageScaled[{1, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.16070065562586858`}, {1.0666666666666667`, 
           0.20726592556422452`}, {2.1333333333333333`, 
           0.22688114545822446`}, {3.2, 0.2351438883135611}, {
           4.266666666666667, 0.23862449775165873`}, {5.333333333333333, 
           0.2400906745736507}, {6.4, 0.24070828896319316`}, {
           7.466666666666667, 0.24096845371852715`}, {8.533333333333333, 
           0.24107804588649484`}, {9.6, 0.24112421064568537`}, {
           10.666666666666666`, 0.24114365715386787`}, {11.733333333333333`, 
           0.2411518488283642}, {12.8, 0.2411552995008667}, {
           13.866666666666667`, 0.24115675306701176`}, {14.933333333333334`, 
           0.24115736536926197`}, {16., 0.24115762329632426`}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.24115781102495687`}, {1.0666666666666667`, 
           0.24115781102495687`}, {2.1333333333333333`, 
           0.24115781102495687`}, {3.2, 0.24115781102495687`}, {
           4.266666666666667, 0.24115781102495687`}, {5.333333333333333, 
           0.24115781102495687`}, {6.4, 0.24115781102495687`}, {
           7.466666666666667, 0.24115781102495687`}, {8.533333333333333, 
           0.24115781102495687`}, {9.6, 0.24115781102495687`}, {
           10.666666666666666`, 0.24115781102495687`}, {11.733333333333333`, 
           0.24115781102495687`}, {12.8, 0.24115781102495687`}, {
           13.866666666666667`, 0.24115781102495687`}, {14.933333333333334`, 
           0.24115781102495687`}, {16., 0.24115781102495687`}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(t\\)]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30, 30}, {30, 30}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.2532155044611405}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}}}], {372., -580.5}, 
      ImageScaled[{1, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.027934754219184416`}, {1.0666666666666667`, 
           0.02147464285566788}, {2.1333333333333333`, 0.01875337644611297}, {
           3.2, 0.01760706635096613}, {4.266666666666667, 
           0.017124193071958328`}, {5.333333333333333, 0.01692078685180297}, {
           6.4, 0.016835103729135874`}, {7.466666666666667, 
           0.016799010449862616`}, {8.533333333333333, 
           0.016783806466065726`}, {9.6, 0.01677740191851697}, {
           10.666666666666666`, 0.016774704057887006`}, {11.733333333333333`, 
           0.01677356760727542}, {12.8, 0.016773088887219154`}, {
           13.866666666666667`, 0.016772887230508397`}, {14.933333333333334`, 
           0.016772802284351532`}, {16., 0.01677276650151277}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.0167727404574702}, {1.0666666666666667`, 
           0.0167727404574702}, {2.1333333333333333`, 0.0167727404574702}, {
           3.2, 0.0167727404574702}, {4.266666666666667, 
           0.0167727404574702}, {5.333333333333333, 0.0167727404574702}, {6.4,
            0.0167727404574702}, {7.466666666666667, 0.0167727404574702}, {
           8.533333333333333, 0.0167727404574702}, {9.6, 
           0.0167727404574702}, {10.666666666666666`, 0.0167727404574702}, {
           11.733333333333333`, 0.0167727404574702}, {12.8, 
           0.0167727404574702}, {13.866666666666667`, 0.0167727404574702}, {
           14.933333333333334`, 0.0167727404574702}, {16., 
           0.0167727404574702}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(R\\), \\(t\\)]\\)/100\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30, 30}, {30, 30}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.029331491930143637`}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.01, 
           FormBox["0.01`", TraditionalForm]}, {0.02, 
           FormBox["0.02`", TraditionalForm]}, {0.03, 
           FormBox["0.03`", TraditionalForm]}}}], {756., -580.5}, 
      ImageScaled[{1, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.2411578110249573}, {1.0666666666666667`, 
           0.31131551133174756`}, {2.1333333333333333`, 
           0.34086883982306365`}, {3.2, 0.35331792554132946`}, {
           4.266666666666667, 0.3585619959432901}, {5.333333333333333, 
           0.3607710155454581}, {6.4, 0.36170154607398386`}, {
           7.466666666666667, 0.362093524064432}, {8.533333333333333, 
           0.3622586414252124}, {9.6, 0.3623281956948282}, {
           10.666666666666666`, 0.36235749483332536`}, {11.733333333333333`, 
           0.36236983684369245`}, {12.8, 0.3623750358095227}, {
           13.866666666666667`, 0.3623772258292115}, {14.933333333333334`, 
           0.3623781483561898}, {16., 0.36237853696275346`}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.3623788198046475}, {1.0666666666666667`, 
           0.3623788198046475}, {2.1333333333333333`, 0.3623788198046475}, {
           3.2, 0.3623788198046475}, {4.266666666666667, 
           0.3623788198046475}, {5.333333333333333, 0.3623788198046475}, {6.4,
            0.3623788198046475}, {7.466666666666667, 0.3623788198046475}, {
           8.533333333333333, 0.3623788198046475}, {9.6, 
           0.3623788198046475}, {10.666666666666666`, 0.3623788198046475}, {
           11.733333333333333`, 0.3623788198046475}, {12.8, 
           0.3623788198046475}, {13.866666666666667`, 0.3623788198046475}, {
           14.933333333333334`, 0.3623788198046475}, {16., 
           0.3623788198046475}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(y\\), \\(t\\)]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30, 30}, {30, 30}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.38049746381089117`}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}, {0.3, 
           FormBox["0.3`", TraditionalForm]}}}], {372., -967.5}, 
      ImageScaled[{1, 0.5}], {360., 360.}], 
     TagBox[InsetBox["", {756., -967.5}, {Right, Center}, {360., 360.}],
      "InsetString"]}}, {}},
  ImageMargins->0.,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.7746898762230387`*^9, 3.774690091313175*^9, 3.7746901535446653`*^9, 
   3.774690313542582*^9, 3.7746904224183903`*^9, 3.7788268293548603`*^9, {
   3.7788268829604797`*^9, 3.7788269037277327`*^9}, 3.778827035762328*^9, {
   3.778827072546422*^9, 3.7788270803651447`*^9}, 3.7789035535185957`*^9, 
   3.7807598058642797`*^9, {3.7807616112506943`*^9, 3.78076162252667*^9}, 
   3.78080482712083*^9, 3.780804859836364*^9, 3.7816960012493343`*^9, 
   3.7816961712044783`*^9, 3.7816963071368103`*^9, 3.78185845601602*^9, 
   3.781858508598176*^9, 3.7818586832774343`*^9, {3.7818588526475773`*^9, 
   3.7818588732618237`*^9}, {3.7818589405969133`*^9, 3.7818589536914043`*^9}, 
   3.7818590022019033`*^9, {3.781859045718363*^9, 3.7818590614966173`*^9}, 
   3.78185909596391*^9, {3.781859127939303*^9, 3.7818591430337877`*^9}, {
   3.781859227158079*^9, 3.781859250600157*^9}, 3.781859289956164*^9, {
   3.7818593277466717`*^9, 3.7818593565217943`*^9}, 3.78185948230343*^9, 
   3.781859513672173*^9, 3.781859549296794*^9, 3.7818595796709547`*^9, 
   3.854430373781426*^9, 3.854430458009329*^9, 3.854430503715768*^9, {
   3.8544305860648527`*^9, 3.854430602350626*^9}, 3.8544306329790897`*^9, 
   3.854430684276207*^9, 3.854430739781474*^9, 3.8544307868400717`*^9, 
   3.8544308527049723`*^9},
 CellLabel->
  "Out[569]=",ExpressionUUID->"2f1d2e75-1b5f-428b-a47e-01adb525dcee"]
}, Open  ]]
},
WindowSize->{1280, 667},
WindowMargins->{{25, Automatic}, {Automatic, 15}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"30e52520-141f-4d57-9b48-05499f3ce5d2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 633, 14, 67, "Input",ExpressionUUID->"128e60b1-37e0-4738-bf2f-1069d9251759"],
Cell[CellGroupData[{
Cell[1216, 38, 35685, 797, 3570, "Input",ExpressionUUID->"4ca19a78-2b0f-451e-948e-1e1529dbd2a6"],
Cell[36904, 837, 6554, 91, 53, "Output",ExpressionUUID->"9d5fbe0b-4f6b-4215-bf84-e9152205be29"],
Cell[43461, 930, 6480, 90, 34, "Output",ExpressionUUID->"b241708d-463d-4dca-81f0-478d4ef4d4d2"],
Cell[49944, 1022, 6495, 90, 34, "Output",ExpressionUUID->"5b3ac3c8-f336-49d0-8d34-abb9b71e33f2"],
Cell[56442, 1114, 7036, 101, 34, "Output",ExpressionUUID->"82d23af4-abf6-408b-9efd-6510164d6205"],
Cell[63481, 1217, 6634, 92, 38, "Output",ExpressionUUID->"346da1b8-c63b-44ee-9fb1-243c766984b4"],
Cell[70118, 1311, 8531, 152, 304, "Output",ExpressionUUID->"58b6eaaf-fe2e-4e19-a1ec-8f527d779722"],
Cell[78652, 1465, 6821, 95, 51, "Output",ExpressionUUID->"e078eafc-d581-4e54-b64f-9c9fbc5e2b6a"],
Cell[85476, 1562, 9171, 138, 300, "Output",ExpressionUUID->"549da4d1-4365-498d-9e46-ccb4da1fbe11"],
Cell[94650, 1702, 9741, 166, 377, "Output",ExpressionUUID->"b5d6473e-618e-45d5-b698-3ec5fbeb0135"],
Cell[104394, 1870, 9727, 166, 377, "Output",ExpressionUUID->"6962f18a-3880-46cf-bff8-813b5ca04a4e"],
Cell[114124, 2038, 9651, 164, 377, "Output",ExpressionUUID->"9dc5d52c-3994-4b27-ba15-fbebc3f24ab5"],
Cell[123778, 2204, 9692, 165, 377, "Output",ExpressionUUID->"110afef5-3ba9-4d02-a126-1ac7b3fef311"],
Cell[133473, 2371, 9659, 165, 377, "Output",ExpressionUUID->"1abd650e-6773-4436-a758-6b31c020f349"],
Cell[143135, 2538, 9088, 157, 377, "Output",ExpressionUUID->"f7013a4d-0b90-478f-970c-3fc407ee1fed"],
Cell[152226, 2697, 24761, 475, 449, "Output",ExpressionUUID->"2f1d2e75-1b5f-428b-a47e-01adb525dcee"]
}, Open  ]]
}
]
*)

