(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    162111,       3003]
NotebookOptionsPosition[    160336,       2973]
NotebookOutlinePosition[    160734,       2989]
CellTagsIndexPosition[    160691,       2986]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.769155249292598*^9, 3.769155478823312*^9}, {
  3.7691555711283903`*^9, 3.76915559150035*^9}, {3.76915643281081*^9, 
  3.769156558536229*^9}, {3.769156675827311*^9, 3.769156676039103*^9}, {
  3.769157054313663*^9, 3.7691570571144953`*^9}, {3.7729954274886217`*^9, 
  3.772995429032259*^9}},
 FontSize->18,
 CellLabel->
  "In[579]:=",ExpressionUUID->"128e60b1-37e0-4738-bf2f-1069d9251759"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Gasteiger", " ", "and", " ", "Prettner", " ", 
    RowBox[{"(", 
     RowBox[{"2022", ",", 
      RowBox[{"p", ".233"}], ",", 
      RowBox[{"Figure", " ", "3"}]}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Last", " ", 
     RowBox[{"checked", ":", " ", 
      RowBox[{"February", " ", "21", "st"}]}]}], ",", "2022"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"IMPORTANT", ":", " ", 
    RowBox[{
    "evaluate", " ", "22", "_MD", "_gasteiger", "_prettner", "_generalized", 
     "_linearized", 
     RowBox[{"_modules", ".", "nb"}], " ", "befure", " ", "using", " ", 
     "this"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"List", " ", "of", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "=", 
     RowBox[{"1", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", 
     RowBox[{"0.98", "^", "25"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "0.009"}], ")"}], "^", "25"}], ")"}], "-", "1"}]}],
     ";", " ", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"World", " ", "Bank", " ", 
         RowBox[{"(", 
          RowBox[{"2019", "a"}], ")"}]}], "\[CloseCurlyQuote]"}], "s", " ", 
       "World", " ", "Development", " ", "Indicators"}], ",", " ", 
      RowBox[{
       RowBox[{"average", " ", "over", " ", "1970"}], "-", 
       RowBox[{
       "2017", " ", "suggest", " ", "a", " ", "value", " ", "of", " ", "0.9", 
        "%"}]}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Mu]", "=", "0.50"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1", "-", "\[Mu]"}]], " ", "=", " ", 
      RowBox[{"2", " ", "following", " ", "De", " ", "Canio", " ", 
       RowBox[{"(", 
        RowBox[{"2016", ",", "JMacro"}], ")"}], " ", "paper"}]}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{"\[Nu]", "=", "0.10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "rather", " ", "low", " ", "share", " ", "of", " ", "robots", " ", "in", 
      " ", "production"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Theta]", "=", "2.00"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"range", " ", "suggested", " ", "by", " ", "Guvenen", " ", 
      RowBox[{"(", 
       RowBox[{"2006", ",", "JME"}], ")"}], " ", "und", " ", "Chetty", " ", 
      RowBox[{"(", 
       RowBox[{"2006", ",", "AER"}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Tau]", "=", "0.50"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Transition", " ", "path"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\"\<Steady state\>\"", "\[IndentingNewLine]", 
   RowBox[{"sslist", "=", 
    RowBox[{"SteadyP", "[", 
     RowBox[{
     "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
      "\[Theta]", ",", "\[Tau]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kss", "=", 
     RowBox[{"kss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pss", "=", 
     RowBox[{"pss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wss", "=", 
     RowBox[{"wss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rss", "=", 
     RowBox[{"Rss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yss", "=", 
     RowBox[{"yss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"revss", "=", 
     RowBox[{"revss", "/.", "sslist"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "time", " ", "horizon", " ", "and", " ", "absolute", " ", "size", " ", 
     "of", " ", "deviation"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "16"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dev", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Convergence", " ", "from", " ", "below"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"klist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wlist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rlist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ylist", "=", 
     RowBox[{
      RowBox[{"DiffEqP", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
        "\[Theta]", ",", "\[Tau]", ",", 
        RowBox[{"-", "dev"}], ",", "tmax"}], "]"}], "[", 
      RowBox[{"[", "5", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"revlist", "=", 
     RowBox[{"Rlist", "+", "plist"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   "\"\<Compare \!\(\*SubscriptBox[OverscriptBox[\(p\), \(^\)], \(t\)]\) and \
\!\(\*SubscriptBox[OverscriptBox[\(k\), \(^\)], \(t\)]\)\>\"", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"plist", ",", "klist"}], "}"}], "]"}], "//", "MatrixForm"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\"\<Compute (\!\(\*FractionBox[\((\*SubscriptBox[\(p\), \(t\)] - p)\), \
\(p\)]\))*p+p=\!\(\*SubscriptBox[\(p\), \(t\)]\) and therefore \
[\!\(\*SubscriptBox[\(p\), \(t\)]\),\!\(\*SubscriptBox[\(k\), \
\(t\)]\),\!\(\*SubscriptBox[\(w\), \(t\)]\),\!\(\*SubscriptBox[\(R\), \
\(t\)]\)/100]\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plevel", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"plist", "*", "pss"}], "+", "pss"}], ")"}], "*", "100"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"klevel", "=", 
     RowBox[{
      RowBox[{"klist", "*", "kss"}], "+", "kss"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wlevel", "=", 
     RowBox[{
      RowBox[{"wlist", "*", "wss"}], "+", "wss"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rlevel", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Rlist", "*", "Rss"}], "+", "Rss"}], ")"}], "/", "100"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ylevel", "=", 
     RowBox[{
      RowBox[{"ylist", "*", "yss"}], "+", "yss"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"revlevel", "=", 
     RowBox[{"\[Tau]", "*", "Rlevel", "*", "plevel", "*", "1000"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
      "plevel", ",", "klevel", ",", "wlevel", ",", "Rlevel", ",", "ylevel", 
       ",", "revlevel"}], "}"}], "]"}], "//", "MatrixForm"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["p", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"padding", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"plevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"pss", "*", "100"}], ",", "tmax"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "klevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(p\), \(t\)]\)*100\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.025", ",", "0.05", ",", "0.075", ",", "0.1"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_p.pdf\>\"", ",", 
      "pplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["k", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"kplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"klevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"kss", ",", "tmax"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "klevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(k\), \(t\)]\)\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.025", ",", "0.05", ",", "0.075", ",", "0.1"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_k.pdf\>\"", ",", 
      "kplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["w", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"wplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"wlevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"wss", ",", "tmax"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "wlevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(w\), \(t\)]\)\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.1", ",", "0.2"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_w.pdf\>\"", ",", 
      "wplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["R", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Rplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Rlevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"Rss", "/", "100"}], ",", "tmax"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "Rlevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(R\), \(t\)]\)/100\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.01", ",", "0.02", ",", "0.03"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_R.pdf\>\"", ",", 
      "Rplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", 
     SubscriptBox["y", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"yplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"ylevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"yss", ",", "tmax"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "ylevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", "\"\<\!\(\*SubscriptBox[\(y\), \(t\)]\)\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.1", ",", "0.2", ",", "0.3"}], "}"}]}], "}"}]}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_y.pdf\>\"", ",", 
      "yplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Plot", " ", "\[Tau]", "*", 
     SubscriptBox["R", "t"], "*", 
     SubscriptBox["p", "t"]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"revplot", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"revlevel", ",", "\[IndentingNewLine]", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"revss", "*", "1000"}], ",", "tmax"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"Max", "[", "revlevel", "]"}], "*", "1.05"}]}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "tmax"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", 
         "\"\<\[Tau]*\!\(\*SubscriptBox[\(R\), \
\(t\)]\)*\!\(\*SubscriptBox[\(p\), \(t\)]\)*1000\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5", ",", "10", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.05", ",", "0.10"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "14"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "14"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"Scaled", "[", ".10", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_rev.pdf\>\"", ",",
       "revplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Combine", " ", "plots"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Levelplot2", "=", 
    RowBox[{"GraphicsGrid", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pplot", ",", "kplot"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"wplot", ",", "Rplot"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"yplot", ",", "revplot"}], "}"}]}], "\[IndentingNewLine]", 
      "}"}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES.pdf\>\"", ",", 
      "Levelplot2"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Tau]", ",", "n", ",", "\[Mu]", ",", 
     "\[Nu]", ",", "\[Theta]", ",", "kss", ",", "pss", ",", "wss", ",", 
     "sslist", ",", "Rss", ",", "yss", ",", "revss", ",", "tmax", ",", "dev", 
     ",", "plist", ",", "klist", ",", "wlist", ",", "Rlist", ",", "revlist", 
     ",", "ylist", ",", "plevel", ",", "klevel", ",", "wlevel", ",", "Rlevel",
      ",", "ylevel", ",", "revlevel", ",", "pplot", ",", "kplot", ",", 
     "wplot", ",", "Rplot", ",", "yplot", ",", "revplot", ",", "padding", ",",
      "Levelplot2"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7733917668802137`*^9, 3.77339179273109*^9}, {
   3.773391829842263*^9, 3.773391978403718*^9}, {3.7733921759468927`*^9, 
   3.773392209641366*^9}, {3.773392310789617*^9, 3.773392313836546*^9}, {
   3.773392360474341*^9, 3.773392419223817*^9}, {3.773392452176407*^9, 
   3.773392464261669*^9}, {3.773392547370617*^9, 3.7733925522013903`*^9}, {
   3.773392601073112*^9, 3.773392680091463*^9}, {3.773392768457448*^9, 
   3.773392779847052*^9}, {3.773392983271264*^9, 3.773393155558972*^9}, {
   3.7733931860392103`*^9, 3.773393205430887*^9}, {3.773393263491508*^9, 
   3.773393446818468*^9}, {3.773393498217054*^9, 3.7733936063003597`*^9}, {
   3.7733936520680017`*^9, 3.7733937653727694`*^9}, {3.77339385709011*^9, 
   3.773393859792488*^9}, {3.77339394803855*^9, 3.773394010746344*^9}, {
   3.773398241575759*^9, 3.773398332402384*^9}, {3.773398375746552*^9, 
   3.773398426743781*^9}, {3.773398470871355*^9, 3.773398485542302*^9}, {
   3.773398519212822*^9, 3.7733985215720787`*^9}, {3.773398554011334*^9, 
   3.773398572049038*^9}, {3.773398603041649*^9, 3.7733986881630507`*^9}, {
   3.7733987369551764`*^9, 3.77339874198531*^9}, {3.7733987813859873`*^9, 
   3.77339880393635*^9}, 3.773398849326689*^9, {3.773398924267037*^9, 
   3.7733992397492867`*^9}, {3.773399291451158*^9, 3.773399358871901*^9}, {
   3.773399426436108*^9, 3.7733994722279797`*^9}, {3.773399535199213*^9, 
   3.7733995961320868`*^9}, {3.773399771542903*^9, 3.773399811083898*^9}, 
   3.773399902713722*^9, {3.773399938751418*^9, 3.773399964484964*^9}, {
   3.7734246189210663`*^9, 3.773424678396941*^9}, {3.773426606999332*^9, 
   3.773426641874914*^9}, {3.773426704212275*^9, 3.773426709993022*^9}, {
   3.7734268528226137`*^9, 3.77342688205868*^9}, {3.773426935701449*^9, 
   3.773426937522723*^9}, {3.77342710006528*^9, 3.7734271381403923`*^9}, 
   3.773427170988928*^9, {3.773427243169565*^9, 3.773427243244726*^9}, {
   3.774029579642405*^9, 3.7740296304919662`*^9}, {3.7740297219179907`*^9, 
   3.774029763421412*^9}, {3.774029800578065*^9, 3.774029810172364*^9}, {
   3.774029950738675*^9, 3.77403000747432*^9}, {3.774030116597883*^9, 
   3.7740301411628933`*^9}, {3.774030176276206*^9, 3.774030212768416*^9}, {
   3.774030280665854*^9, 3.7740303093474903`*^9}, {3.774073708843416*^9, 
   3.7740737476970882`*^9}, {3.774084671571754*^9, 3.7740846794229097`*^9}, {
   3.774084750854319*^9, 3.774084751019547*^9}, {3.77408483897779*^9, 
   3.77408484056819*^9}, {3.774084886798933*^9, 3.7740848946214*^9}, 
   3.774084932078457*^9, {3.774085043169739*^9, 3.774085045783342*^9}, 
   3.774085091729251*^9, {3.774085121918262*^9, 3.774085137220755*^9}, {
   3.774085194292819*^9, 3.774085196200794*^9}, {3.774178297912943*^9, 
   3.774178369796216*^9}, {3.774178458472351*^9, 3.774178526437737*^9}, {
   3.774180896717987*^9, 3.7741809094044123`*^9}, {3.774180986377933*^9, 
   3.774180991239732*^9}, {3.774181031854864*^9, 3.7741811567761097`*^9}, {
   3.774181231477806*^9, 3.774181246883071*^9}, {3.774181350272564*^9, 
   3.7741814442657633`*^9}, {3.774181479370158*^9, 3.774181495592381*^9}, {
   3.774181527766824*^9, 3.774181539558145*^9}, {3.774181620318185*^9, 
   3.7741816206675987`*^9}, {3.7741816551480627`*^9, 
   3.7741816840108423`*^9}, {3.7741817550143967`*^9, 
   3.7741817577091084`*^9}, {3.774181967648059*^9, 3.774181969316431*^9}, {
   3.774182155541313*^9, 3.774182156276134*^9}, {3.7741822149230137`*^9, 
   3.774182218464904*^9}, {3.774182342305931*^9, 3.7741823786731987`*^9}, {
   3.774230685007359*^9, 3.7742309168032923`*^9}, {3.774230964735941*^9, 
   3.774230968834917*^9}, {3.774231015924121*^9, 3.7742310815871897`*^9}, {
   3.7742311558183823`*^9, 3.7742311590792713`*^9}, 3.77423122401649*^9, {
   3.7742313060132523`*^9, 3.774231310459304*^9}, {3.77423134277321*^9, 
   3.774231360849763*^9}, {3.774231417404829*^9, 3.7742314356615458`*^9}, 
   3.774231644577116*^9, {3.774231863628902*^9, 3.77423186947793*^9}, {
   3.774231929125705*^9, 3.7742319389189863`*^9}, {3.774232057086616*^9, 
   3.7742320753745832`*^9}, {3.77423211706817*^9, 3.7742321193892117`*^9}, {
   3.7742321570764513`*^9, 3.7742321632799892`*^9}, 3.774232208836399*^9, {
   3.774232248829008*^9, 3.774232264924375*^9}, {3.774232314092317*^9, 
   3.7742323216834917`*^9}, {3.7742323630399218`*^9, 3.774232401209587*^9}, {
   3.774232482536457*^9, 3.774232606123908*^9}, {3.774232658873457*^9, 
   3.77423267290432*^9}, {3.774232756715013*^9, 3.774232819200328*^9}, {
   3.774237915953712*^9, 3.7742380103045883`*^9}, 3.774238100274572*^9, {
   3.774238144320325*^9, 3.7742381639666147`*^9}, {3.7742382015044117`*^9, 
   3.7742382051881943`*^9}, {3.774238465149507*^9, 3.774238493068646*^9}, {
   3.7742385654290237`*^9, 3.77423856606706*^9}, {3.774238598700519*^9, 
   3.7742386055158663`*^9}, {3.774242842070105*^9, 3.774242862113349*^9}, {
   3.7742429791435633`*^9, 3.774242979868896*^9}, {3.774243040716538*^9, 
   3.774243071272138*^9}, {3.774243170862297*^9, 3.774243229279975*^9}, {
   3.774243289513026*^9, 3.774243293469123*^9}, {3.774243331245906*^9, 
   3.7742433363875723`*^9}, {3.774243373723495*^9, 3.774243376226061*^9}, {
   3.77424342715322*^9, 3.774243446190815*^9}, {3.774243481399125*^9, 
   3.774243520784573*^9}, {3.774243573176964*^9, 3.774243574150716*^9}, 
   3.7742438013593597`*^9, {3.774243834188552*^9, 3.7742438391560097`*^9}, {
   3.774243899332137*^9, 3.774243923030896*^9}, {3.774244069666292*^9, 
   3.774244092023683*^9}, {3.774244143590818*^9, 3.774244144196745*^9}, {
   3.774244355221249*^9, 3.7742443573641663`*^9}, {3.774247358528124*^9, 
   3.774247358710548*^9}, 3.7742474290783653`*^9, 3.774251148025975*^9, 
   3.7742513512033367`*^9, {3.7742526775297194`*^9, 3.7742526779519167`*^9}, 
   3.774253493852786*^9, {3.7742688435877237`*^9, 3.774268900401936*^9}, {
   3.774348548642095*^9, 3.774348563023197*^9}, {3.774348653102703*^9, 
   3.7743486536275473`*^9}, {3.774348683804538*^9, 3.774348710165668*^9}, {
   3.774348823059702*^9, 3.7743488765993147`*^9}, {3.7743489243102217`*^9, 
   3.774348960356777*^9}, {3.774348990783209*^9, 3.774349033546344*^9}, {
   3.77434906995259*^9, 3.774349104519968*^9}, {3.774606478370194*^9, 
   3.774606521589222*^9}, 3.774606568035166*^9, 3.7746066922719*^9, {
   3.7746067377395678`*^9, 3.7746067502983294`*^9}, {3.774606946308014*^9, 
   3.7746069524819183`*^9}, {3.774607239983203*^9, 3.774607261733411*^9}, {
   3.7746072948270597`*^9, 3.774607306195703*^9}, {3.774607391514312*^9, 
   3.774607562327792*^9}, {3.774607960905622*^9, 3.774608088545203*^9}, {
   3.774608334551139*^9, 3.774608414348881*^9}, {3.774608447267157*^9, 
   3.774608694468364*^9}, 3.774608813712681*^9, 3.7746089154325953`*^9, {
   3.7746089860299*^9, 3.774609009921699*^9}, {3.774609154550202*^9, 
   3.774609212979765*^9}, 3.774688373247308*^9, {3.774688545268695*^9, 
   3.774688553389523*^9}, {3.774688614585575*^9, 3.7746886232706127`*^9}, {
   3.774688819289933*^9, 3.7746890764997587`*^9}, {3.774689107515276*^9, 
   3.774689144491535*^9}, {3.7746892327128077`*^9, 3.774689284980563*^9}, {
   3.77468934898967*^9, 3.77468934937077*^9}, 3.7746893839088163`*^9, {
   3.774689455120772*^9, 3.774689480743602*^9}, {3.774689528711199*^9, 
   3.774689534774197*^9}, {3.77469018398787*^9, 3.7746901853227167`*^9}, {
   3.774690217019351*^9, 3.774690234127903*^9}, {3.774690264514485*^9, 
   3.7746902770078573`*^9}, 3.778903473768394*^9, 3.778903504864859*^9, {
   3.780804899687687*^9, 3.780804900079907*^9}, {3.780850645319001*^9, 
   3.7808506679020653`*^9}, {3.781697160701058*^9, 3.781697165875458*^9}, {
   3.781697195930677*^9, 3.7816972359105053`*^9}, {3.781859654492982*^9, 
   3.7818596757455597`*^9}, {3.854431545409153*^9, 3.854431549793288*^9}, {
   3.854431604442163*^9, 3.854431721996891*^9}, 
   3.854433035486339*^9},ExpressionUUID->"4ca19a78-2b0f-451e-948e-\
1e1529dbd2a6"],

Cell[BoxData["\<\"Steady state\"\>"], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.8544317349718533`*^9},
 CellLabel->
  "Out[587]=",ExpressionUUID->"89a3631b-a4f7-4580-90f8-9eae09e687a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"kss", "\[Rule]", "0.07239529469561404`"}], ",", 
   RowBox[{"pss", "\[Rule]", "0.00011475718587241438`"}], ",", 
   RowBox[{"wss", "\[Rule]", "0.2415318500043812`"}], ",", 
   RowBox[{"Rss", "\[Rule]", "1.6701316047237764`"}], ",", 
   RowBox[{"yss", "\[Rule]", "0.3627290091133099`"}], ",", 
   RowBox[{"revss", "\[Rule]", "0.00009582980149734006`"}], ",", 
   RowBox[{"c1ss", "\[Rule]", "0.15091304181643272`"}], ",", 
   RowBox[{"c2ss", "\[Rule]", "0.1515053839172497`"}], ",", 
   RowBox[{"savess", "\[Rule]", "0.09071463798944585`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.854431734973604*^9},
 CellLabel->
  "Out[588]=",ExpressionUUID->"58ee7a81-cf3f-4fd3-85e2-51cf273707a3"],

Cell[BoxData["\<\"Compare \\!\\(\\*SubscriptBox[OverscriptBox[\\(p\\), \
\\(^\\)], \\(t\\)]\\) and \\!\\(\\*SubscriptBox[OverscriptBox[\\(k\\), \
\\(^\\)], \\(t\\)]\\)\"\>"], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.8544317349749527`*^9},
 CellLabel->
  "Out[603]=",ExpressionUUID->"32d6975b-c1b6-4a52-a69d-d3605cca503b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1.`"}], 
      RowBox[{"-", "1.0000000000000002`"}]},
     {
      RowBox[{"-", "0.42128801355943307`"}], 
      RowBox[{"-", "0.4212880135594331`"}]},
     {
      RowBox[{"-", "0.17748359036885306`"}], 
      RowBox[{"-", "0.17748359036885308`"}]},
     {
      RowBox[{"-", "0.07477170922589023`"}], 
      RowBox[{"-", "0.07477170922589024`"}]},
     {
      RowBox[{"-", "0.03150042485021883`"}], 
      RowBox[{"-", "0.03150042485021883`"}]},
     {
      RowBox[{"-", "0.013270751411426893`"}], 
      RowBox[{"-", "0.013270751411426895`"}]},
     {
      RowBox[{"-", "0.005590808500561079`"}], 
      RowBox[{"-", "0.00559080850056108`"}]},
     {
      RowBox[{"-", "0.0023553406073925694`"}], 
      RowBox[{"-", "0.00235534060739257`"}]},
     {
      RowBox[{"-", "0.0009922767657442842`"}], 
      RowBox[{"-", "0.0009922767657442844`"}]},
     {
      RowBox[{"-", "0.0004180343075415884`"}], 
      RowBox[{"-", "0.00041803430754158846`"}]},
     {
      RowBox[{"-", "0.00017611284302388892`"}], 
      RowBox[{"-", "0.00017611284302388895`"}]},
     {
      RowBox[{"-", "0.00007419422979983842`"}], 
      RowBox[{"-", "0.00007419422979983843`"}]},
     {
      RowBox[{"-", "0.00003125713968994602`"}], 
      RowBox[{"-", "0.00003125713968994603`"}]},
     {
      RowBox[{"-", "0.000013168258289527073`"}], 
      RowBox[{"-", "0.000013168258289527077`"}]},
     {
      RowBox[{"-", "5.547629376832399`*^-6"}], 
      RowBox[{"-", "5.5476293768323995`*^-6"}]},
     {
      RowBox[{"-", "2.3371497601296766`*^-6"}], 
      RowBox[{"-", "2.337149760129677`*^-6"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.854431734976694*^9},
 CellLabel->
  "Out[604]//MatrixForm=",ExpressionUUID->"a2c3752c-7154-4e47-953e-\
c969dc8d0685"],

Cell[BoxData["\<\"Compute (\\!\\(\\*FractionBox[\\((\\*SubscriptBox[\\(p\\), \
\\(t\\)] - p)\\), \\(p\\)]\\))*p+p=\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\) \
and therefore [\\!\\(\\*SubscriptBox[\\(p\\), \
\\(t\\)]\\),\\!\\(\\*SubscriptBox[\\(k\\), \\(t\\)]\\),\\!\\(\\*SubscriptBox[\
\\(w\\), \\(t\\)]\\),\\!\\(\\*SubscriptBox[\\(R\\), \\(t\\)]\\)/100]\"\>"], \
"Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.8544317349782467`*^9},
 CellLabel->
  "Out[605]=",ExpressionUUID->"20272971-2f8e-4f5c-b469-1da859440e0f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.`", 
      RowBox[{"-", "1.3877787807814457`*^-17"}], "0.16097337539962714`", 
      "0.0278222897246893`", "0.24153185000438127`", "0.`"},
     {"0.00664113589945543`", "0.041896024802249035`", "0.20759353026276633`",
       "0.021386448956658068`", "0.3116700987032628`", "0.07101515696396651`"},
     {"0.009438966850315245`", "0.05954631786722527`", "0.2272340426968914`", 
      "0.01867510638390937`", "0.3412185021721521`", "0.08813685504191558`"},
     {"0.010617659493878079`", "0.06698217477131095`", "0.23550835516555327`",
       "0.01753285025735695`", "0.35366689037341315`", "0.09307891699488438`"},
     {"0.01111422857628178`", "0.07011481215554541`", "0.2389942238290459`", 
      "0.01705163144282559`", "0.3589112471107391`", "0.09475786472703854`"},
     {"0.011323427178602666`", "0.07143455473635155`", "0.24046277851381778`",
       "0.016848899724364246`", "0.3611206317430042`", "0.09539364453420852`"},
     {"0.011411560042213841`", "0.07199054646662917`", "0.2410814629997687`", 
      "0.016763491281408176`", "0.36205141900591986`", "0.09564879363745882`"},
     {"0.011448689361253898`", "0.0722247791182333`", "0.24134210735787504`", 
      "0.01672750972813401`", "0.36244354852296`", "0.09575403133237946`"},
     {"0.011464331498317099`", "0.07232345852673837`", "0.24145191370174712`",
       "0.016712351131030354`", "0.3626087479882519`", "0.09579796674120333`"},
     {"0.011470921343168279`", "0.0723650309787267`", "0.2414981737982332`", 
      "0.016705964995768204`", "0.3626783445428258`", 
      "0.09581640521408984`"},
     {"0.011473697565815297`", "0.07238254495444364`", "0.2415176626223889`", 
      "0.016703274593529296`", "0.3627076647370528`", "0.0958241605224608`"},
     {"0.011474867155139458`", "0.07238992338248297`", "0.24152587303040407`",
       "0.01670214115931439`", "0.36272001698343587`", "0.09582742550475977`"},
     {"0.011475359889102515`", "0.07239303182577485`", "0.24152933197688728`",
       "0.016701663657065487`", "0.3627252208367776`", "0.09582880060578526`"},
     {"0.011475567472015023`", "0.07239434137567453`", "0.2415307891895802`", 
      "0.01670146249109158`", "0.3627274131578148`", "0.09582937984892477`"},
     {"0.011475654924207882`", "0.07239489307335044`", "0.24153140309582094`",
       "0.016701377742278038`", "0.36272833675638966`", 
      "0.09582962386461444`"},
     {"0.011475691766768496`", "0.0723951254969684`", "0.24153166172716162`", 
      "0.016701342038618727`", "0.36272872585739857`", 
      "0.09582972666328074`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.854431734980233*^9},
 CellLabel->
  "Out[612]//MatrixForm=",ExpressionUUID->"027212ea-bc0f-4dbb-8e16-\
61e71f2bca42"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.}, {1.0666666666666667`, 0.00664113589945543}, {
      2.1333333333333333`, 0.009438966850315245}, {3.2, 
      0.010617659493878079`}, {4.266666666666667, 0.01111422857628178}, {
      5.333333333333333, 0.011323427178602666`}, {6.4, 
      0.011411560042213841`}, {7.466666666666667, 0.011448689361253898`}, {
      8.533333333333333, 0.011464331498317099`}, {9.6, 
      0.011470921343168279`}, {10.666666666666666`, 0.011473697565815297`}, {
      11.733333333333333`, 0.011474867155139458`}, {12.8, 
      0.011475359889102515`}, {13.866666666666667`, 0.011475567472015023`}, {
      14.933333333333334`, 0.011475654924207882`}, {16., 
      0.011475691766768496`}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.011475718587241439`}, {1.0666666666666667`, 
      0.011475718587241439`}, {2.1333333333333333`, 0.011475718587241439`}, {
      3.2, 0.011475718587241439`}, {4.266666666666667, 
      0.011475718587241439`}, {5.333333333333333, 0.011475718587241439`}, {
      6.4, 0.011475718587241439`}, {7.466666666666667, 
      0.011475718587241439`}, {8.533333333333333, 0.011475718587241439`}, {
      9.6, 0.011475718587241439`}, {10.666666666666666`, 
      0.011475718587241439`}, {11.733333333333333`, 0.011475718587241439`}, {
      12.8, 0.011475718587241439`}, {13.866666666666667`, 
      0.011475718587241439`}, {14.933333333333334`, 0.011475718587241439`}, {
      16., 0.011475718587241439`}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*100\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.07601488177181683}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.025, 
      FormBox["0.025`", TraditionalForm]}, {0.05, 
      FormBox["0.05`", TraditionalForm]}, {0.075, 
      FormBox["0.075`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.854431735006124*^9},
 CellLabel->
  "Out[614]=",ExpressionUUID->"38e77eec-8fbd-46a0-bbee-a730a9e6a376"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{3.533264487869528*^-16, 0.}, {1.0666666666666667`, 
      0.041896024802249035`}, {2.1333333333333333`, 0.05954631786722527}, {
      3.2, 0.06698217477131095}, {4.266666666666667, 0.07011481215554541}, {
      5.333333333333333, 0.07143455473635155}, {6.4, 0.07199054646662917}, {
      7.466666666666667, 0.0722247791182333}, {8.533333333333333, 
      0.07232345852673837}, {9.6, 0.0723650309787267}, {10.666666666666666`, 
      0.07238254495444364}, {11.733333333333333`, 0.07238992338248297}, {12.8,
       0.07239303182577485}, {13.866666666666667`, 0.07239434137567453}, {
      14.933333333333334`, 0.07239489307335044}, {16., 0.0723951254969684}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.07239529469561404}, {1.0666666666666667`, 
      0.07239529469561404}, {2.1333333333333333`, 0.07239529469561404}, {3.2, 
      0.07239529469561404}, {4.266666666666667, 0.07239529469561404}, {
      5.333333333333333, 0.07239529469561404}, {6.4, 0.07239529469561404}, {
      7.466666666666667, 0.07239529469561404}, {8.533333333333333, 
      0.07239529469561404}, {9.6, 0.07239529469561404}, {10.666666666666666`, 
      0.07239529469561404}, {11.733333333333333`, 0.07239529469561404}, {12.8,
       0.07239529469561404}, {13.866666666666667`, 0.07239529469561404}, {
      14.933333333333334`, 0.07239529469561404}, {16., 
      0.07239529469561404}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(t\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.07601488177181683}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.025, 
      FormBox["0.025`", TraditionalForm]}, {0.05, 
      FormBox["0.05`", TraditionalForm]}, {0.075, 
      FormBox["0.075`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.85443173518666*^9},
 CellLabel->
  "Out[616]=",ExpressionUUID->"7afc2553-f867-4b20-b715-62ecb9b2df43"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.16097337539962714`}, {1.0666666666666667`, 
      0.20759353026276633`}, {2.1333333333333333`, 0.2272340426968914}, {3.2, 
      0.23550835516555327`}, {4.266666666666667, 0.2389942238290459}, {
      5.333333333333333, 0.24046277851381778`}, {6.4, 0.2410814629997687}, {
      7.466666666666667, 0.24134210735787504`}, {8.533333333333333, 
      0.24145191370174712`}, {9.6, 0.2414981737982332}, {10.666666666666666`, 
      0.2415176626223889}, {11.733333333333333`, 0.24152587303040407`}, {12.8,
       0.24152933197688728`}, {13.866666666666667`, 0.2415307891895802}, {
      14.933333333333334`, 0.24153140309582094`}, {16., 
      0.24153166172716162`}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.2415318500043812}, {1.0666666666666667`, 
      0.2415318500043812}, {2.1333333333333333`, 0.2415318500043812}, {3.2, 
      0.2415318500043812}, {4.266666666666667, 0.2415318500043812}, {
      5.333333333333333, 0.2415318500043812}, {6.4, 0.2415318500043812}, {
      7.466666666666667, 0.2415318500043812}, {8.533333333333333, 
      0.2415318500043812}, {9.6, 0.2415318500043812}, {10.666666666666666`, 
      0.2415318500043812}, {11.733333333333333`, 0.2415318500043812}, {12.8, 
      0.2415318500043812}, {13.866666666666667`, 0.2415318500043812}, {
      14.933333333333334`, 0.2415318500043812}, {16., 
      0.2415318500043812}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(t\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.25360824481351973`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.854431735345298*^9},
 CellLabel->
  "Out[618]=",ExpressionUUID->"7238622e-27f4-4ba5-af87-e8755b0b82a3"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.0278222897246893}, {1.0666666666666667`, 
      0.021386448956658068`}, {2.1333333333333333`, 0.01867510638390937}, {
      3.2, 0.01753285025735695}, {4.266666666666667, 0.01705163144282559}, {
      5.333333333333333, 0.016848899724364246`}, {6.4, 
      0.016763491281408176`}, {7.466666666666667, 0.01672750972813401}, {
      8.533333333333333, 0.016712351131030354`}, {9.6, 
      0.016705964995768204`}, {10.666666666666666`, 0.016703274593529296`}, {
      11.733333333333333`, 0.01670214115931439}, {12.8, 
      0.016701663657065487`}, {13.866666666666667`, 0.01670146249109158}, {
      14.933333333333334`, 0.016701377742278038`}, {16., 
      0.016701342038618727`}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.016701316047237763`}, {1.0666666666666667`, 
      0.016701316047237763`}, {2.1333333333333333`, 0.016701316047237763`}, {
      3.2, 0.016701316047237763`}, {4.266666666666667, 
      0.016701316047237763`}, {5.333333333333333, 0.016701316047237763`}, {
      6.4, 0.016701316047237763`}, {7.466666666666667, 
      0.016701316047237763`}, {8.533333333333333, 0.016701316047237763`}, {
      9.6, 0.016701316047237763`}, {10.666666666666666`, 
      0.016701316047237763`}, {11.733333333333333`, 0.016701316047237763`}, {
      12.8, 0.016701316047237763`}, {13.866666666666667`, 
      0.016701316047237763`}, {14.933333333333334`, 0.016701316047237763`}, {
      16., 0.016701316047237763`}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(R\\), \\(t\\)]\\)/100\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.029213404210923766`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.01, 
      FormBox["0.01`", TraditionalForm]}, {0.02, 
      FormBox["0.02`", TraditionalForm]}, {0.03, 
      FormBox["0.03`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.854431735511047*^9},
 CellLabel->
  "Out[620]=",ExpressionUUID->"717b00ff-2ad0-45fd-ba66-9e9382c12c9c"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.24153185000438127`}, {1.0666666666666667`, 
      0.3116700987032628}, {2.1333333333333333`, 0.3412185021721521}, {3.2, 
      0.35366689037341315`}, {4.266666666666667, 0.3589112471107391}, {
      5.333333333333333, 0.3611206317430042}, {6.4, 0.36205141900591986`}, {
      7.466666666666667, 0.36244354852296}, {8.533333333333333, 
      0.3626087479882519}, {9.6, 0.3626783445428258}, {10.666666666666666`, 
      0.3627076647370528}, {11.733333333333333`, 0.36272001698343587`}, {12.8,
       0.3627252208367776}, {13.866666666666667`, 0.3627274131578148}, {
      14.933333333333334`, 0.36272833675638966`}, {16., 
      0.36272872585739857`}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.3627290091133099}, {1.0666666666666667`, 
      0.3627290091133099}, {2.1333333333333333`, 0.3627290091133099}, {3.2, 
      0.3627290091133099}, {4.266666666666667, 0.3627290091133099}, {
      5.333333333333333, 0.3627290091133099}, {6.4, 0.3627290091133099}, {
      7.466666666666667, 0.3627290091133099}, {8.533333333333333, 
      0.3627290091133099}, {9.6, 0.3627290091133099}, {10.666666666666666`, 
      0.3627290091133099}, {11.733333333333333`, 0.3627290091133099}, {12.8, 
      0.3627290091133099}, {13.866666666666667`, 0.3627290091133099}, {
      14.933333333333334`, 0.3627290091133099}, {16., 
      0.3627290091133099}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(y\\), \\(t\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.3808651621502685}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.3, 
      FormBox["0.3`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.8544317356891317`*^9},
 CellLabel->
  "Out[622]=",ExpressionUUID->"40f866ef-ddf3-4d97-bab2-522e96899564"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     LineBox[{{0., 0.}, {1.0666666666666667`, 0.07101515696396651}, {
      2.1333333333333333`, 0.08813685504191558}, {3.2, 0.09307891699488438}, {
      4.266666666666667, 0.09475786472703854}, {5.333333333333333, 
      0.09539364453420852}, {6.4, 0.09564879363745882}, {7.466666666666667, 
      0.09575403133237946}, {8.533333333333333, 0.09579796674120333}, {9.6, 
      0.09581640521408984}, {10.666666666666666`, 0.0958241605224608}, {
      11.733333333333333`, 0.09582742550475977}, {12.8, 
      0.09582880060578526}, {13.866666666666667`, 0.09582937984892477}, {
      14.933333333333334`, 0.09582962386461444}, {16., 
      0.09582972666328074}}]}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     Dashing[{Small, Small}], 
     LineBox[{{0., 0.09582980149734006}, {1.0666666666666667`, 
      0.09582980149734006}, {2.1333333333333333`, 0.09582980149734006}, {3.2, 
      0.09582980149734006}, {4.266666666666667, 0.09582980149734006}, {
      5.333333333333333, 0.09582980149734006}, {6.4, 0.09582980149734006}, {
      7.466666666666667, 0.09582980149734006}, {8.533333333333333, 
      0.09582980149734006}, {9.6, 0.09582980149734006}, {10.666666666666666`, 
      0.09582980149734006}, {11.733333333333333`, 0.09582980149734006}, {12.8,
       0.09582980149734006}, {13.866666666666667`, 0.09582980149734006}, {
      14.933333333333334`, 0.09582980149734006}, {16., 
      0.09582980149734006}}]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t\"", TraditionalForm], 
    FormBox[
    "\"\[Tau]*\\!\\(\\*SubscriptBox[\\(R\\), \
\\(t\\)]\\)*\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*1000\"", 
     TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImagePadding->{{30, 30}, {30, 30}},
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 17}, {0, 0.10062121299644478`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {None, 
     Scaled[0.1]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {0.05, 
      FormBox["0.05`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.85443173586097*^9},
 CellLabel->
  "Out[624]=",ExpressionUUID->"1b0b21d3-0b4e-45ab-bf90-89e22efe976d"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.}, {1.0666666666666667`, 0.00664113589945543}, {
           2.1333333333333333`, 0.009438966850315245}, {3.2, 
           0.010617659493878079`}, {4.266666666666667, 0.01111422857628178}, {
           5.333333333333333, 0.011323427178602666`}, {6.4, 
           0.011411560042213841`}, {7.466666666666667, 
           0.011448689361253898`}, {8.533333333333333, 
           0.011464331498317099`}, {9.6, 0.011470921343168279`}, {
           10.666666666666666`, 0.011473697565815297`}, {11.733333333333333`, 
           0.011474867155139458`}, {12.8, 0.011475359889102515`}, {
           13.866666666666667`, 0.011475567472015023`}, {14.933333333333334`, 
           0.011475654924207882`}, {16., 0.011475691766768496`}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.011475718587241439`}, {1.0666666666666667`, 
           0.011475718587241439`}, {2.1333333333333333`, 
           0.011475718587241439`}, {3.2, 0.011475718587241439`}, {
           4.266666666666667, 0.011475718587241439`}, {5.333333333333333, 
           0.011475718587241439`}, {6.4, 0.011475718587241439`}, {
           7.466666666666667, 0.011475718587241439`}, {8.533333333333333, 
           0.011475718587241439`}, {9.6, 0.011475718587241439`}, {
           10.666666666666666`, 0.011475718587241439`}, {11.733333333333333`, 
           0.011475718587241439`}, {12.8, 0.011475718587241439`}, {
           13.866666666666667`, 0.011475718587241439`}, {14.933333333333334`, 
           0.011475718587241439`}, {16., 0.011475718587241439`}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*100\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30.000000000000004`, 30.000000000000057`}, {30., 
        30.00000000000003}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.07601488177181683}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.025, 
           FormBox["0.025`", TraditionalForm]}, {0.05, 
           FormBox["0.05`", TraditionalForm]}, {0.075, 
           FormBox["0.075`", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}}}], {192., -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{3.533264487869528*^-16, 0.}, {1.0666666666666667`, 
           0.041896024802249035`}, {2.1333333333333333`, 
           0.05954631786722527}, {3.2, 0.06698217477131095}, {
           4.266666666666667, 0.07011481215554541}, {5.333333333333333, 
           0.07143455473635155}, {6.4, 0.07199054646662917}, {
           7.466666666666667, 0.0722247791182333}, {8.533333333333333, 
           0.07232345852673837}, {9.6, 0.0723650309787267}, {
           10.666666666666666`, 0.07238254495444364}, {11.733333333333333`, 
           0.07238992338248297}, {12.8, 0.07239303182577485}, {
           13.866666666666667`, 0.07239434137567453}, {14.933333333333334`, 
           0.07239489307335044}, {16., 0.0723951254969684}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.07239529469561404}, {1.0666666666666667`, 
           0.07239529469561404}, {2.1333333333333333`, 0.07239529469561404}, {
           3.2, 0.07239529469561404}, {4.266666666666667, 
           0.07239529469561404}, {5.333333333333333, 0.07239529469561404}, {
           6.4, 0.07239529469561404}, {7.466666666666667, 
           0.07239529469561404}, {8.533333333333333, 0.07239529469561404}, {
           9.6, 0.07239529469561404}, {10.666666666666666`, 
           0.07239529469561404}, {11.733333333333333`, 0.07239529469561404}, {
           12.8, 0.07239529469561404}, {13.866666666666667`, 
           0.07239529469561404}, {14.933333333333334`, 0.07239529469561404}, {
           16., 0.07239529469561404}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(t\\)]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30.000000000000004`, 30.000000000000057`}, {30., 
        30.00000000000003}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.07601488177181683}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.025, 
           FormBox["0.025`", TraditionalForm]}, {0.05, 
           FormBox["0.05`", TraditionalForm]}, {0.075, 
           FormBox["0.075`", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}}}], {576., -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.16097337539962714`}, {1.0666666666666667`, 
           0.20759353026276633`}, {2.1333333333333333`, 0.2272340426968914}, {
           3.2, 0.23550835516555327`}, {4.266666666666667, 
           0.2389942238290459}, {5.333333333333333, 0.24046277851381778`}, {
           6.4, 0.2410814629997687}, {7.466666666666667, 
           0.24134210735787504`}, {8.533333333333333, 0.24145191370174712`}, {
           9.6, 0.2414981737982332}, {10.666666666666666`, 
           0.2415176626223889}, {11.733333333333333`, 0.24152587303040407`}, {
           12.8, 0.24152933197688728`}, {13.866666666666667`, 
           0.2415307891895802}, {14.933333333333334`, 0.24153140309582094`}, {
           16., 0.24153166172716162`}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.2415318500043812}, {1.0666666666666667`, 
           0.2415318500043812}, {2.1333333333333333`, 0.2415318500043812}, {
           3.2, 0.2415318500043812}, {4.266666666666667, 
           0.2415318500043812}, {5.333333333333333, 0.2415318500043812}, {6.4,
            0.2415318500043812}, {7.466666666666667, 0.2415318500043812}, {
           8.533333333333333, 0.2415318500043812}, {9.6, 
           0.2415318500043812}, {10.666666666666666`, 0.2415318500043812}, {
           11.733333333333333`, 0.2415318500043812}, {12.8, 
           0.2415318500043812}, {13.866666666666667`, 0.2415318500043812}, {
           14.933333333333334`, 0.2415318500043812}, {16., 
           0.2415318500043812}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(t\\)]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30.000000000000004`, 30.000000000000057`}, {30., 
        30.00000000000003}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.25360824481351973`}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}}}], {192., -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.0278222897246893}, {1.0666666666666667`, 
           0.021386448956658068`}, {2.1333333333333333`, 
           0.01867510638390937}, {3.2, 0.01753285025735695}, {
           4.266666666666667, 0.01705163144282559}, {5.333333333333333, 
           0.016848899724364246`}, {6.4, 0.016763491281408176`}, {
           7.466666666666667, 0.01672750972813401}, {8.533333333333333, 
           0.016712351131030354`}, {9.6, 0.016705964995768204`}, {
           10.666666666666666`, 0.016703274593529296`}, {11.733333333333333`, 
           0.01670214115931439}, {12.8, 0.016701663657065487`}, {
           13.866666666666667`, 0.01670146249109158}, {14.933333333333334`, 
           0.016701377742278038`}, {16., 0.016701342038618727`}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.016701316047237763`}, {1.0666666666666667`, 
           0.016701316047237763`}, {2.1333333333333333`, 
           0.016701316047237763`}, {3.2, 0.016701316047237763`}, {
           4.266666666666667, 0.016701316047237763`}, {5.333333333333333, 
           0.016701316047237763`}, {6.4, 0.016701316047237763`}, {
           7.466666666666667, 0.016701316047237763`}, {8.533333333333333, 
           0.016701316047237763`}, {9.6, 0.016701316047237763`}, {
           10.666666666666666`, 0.016701316047237763`}, {11.733333333333333`, 
           0.016701316047237763`}, {12.8, 0.016701316047237763`}, {
           13.866666666666667`, 0.016701316047237763`}, {14.933333333333334`, 
           0.016701316047237763`}, {16., 0.016701316047237763`}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(R\\), \\(t\\)]\\)/100\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30.000000000000004`, 30.000000000000057`}, {30., 
        30.00000000000003}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.029213404210923766`}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.01, 
           FormBox["0.01`", TraditionalForm]}, {0.02, 
           FormBox["0.02`", TraditionalForm]}, {0.03, 
           FormBox["0.03`", TraditionalForm]}}}], {576., -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.24153185000438127`}, {1.0666666666666667`, 
           0.3116700987032628}, {2.1333333333333333`, 0.3412185021721521}, {
           3.2, 0.35366689037341315`}, {4.266666666666667, 
           0.3589112471107391}, {5.333333333333333, 0.3611206317430042}, {6.4,
            0.36205141900591986`}, {7.466666666666667, 0.36244354852296}, {
           8.533333333333333, 0.3626087479882519}, {9.6, 
           0.3626783445428258}, {10.666666666666666`, 0.3627076647370528}, {
           11.733333333333333`, 0.36272001698343587`}, {12.8, 
           0.3627252208367776}, {13.866666666666667`, 0.3627274131578148}, {
           14.933333333333334`, 0.36272833675638966`}, {16., 
           0.36272872585739857`}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.3627290091133099}, {1.0666666666666667`, 
           0.3627290091133099}, {2.1333333333333333`, 0.3627290091133099}, {
           3.2, 0.3627290091133099}, {4.266666666666667, 
           0.3627290091133099}, {5.333333333333333, 0.3627290091133099}, {6.4,
            0.3627290091133099}, {7.466666666666667, 0.3627290091133099}, {
           8.533333333333333, 0.3627290091133099}, {9.6, 
           0.3627290091133099}, {10.666666666666666`, 0.3627290091133099}, {
           11.733333333333333`, 0.3627290091133099}, {12.8, 
           0.3627290091133099}, {13.866666666666667`, 0.3627290091133099}, {
           14.933333333333334`, 0.3627290091133099}, {16., 
           0.3627290091133099}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(y\\), \\(t\\)]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30.000000000000004`, 30.000000000000057`}, {30., 
        30.00000000000003}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.3808651621502685}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}, {0.3, 
           FormBox["0.3`", TraditionalForm]}}}], {192., -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           LineBox[{{0., 0.}, {1.0666666666666667`, 0.07101515696396651}, {
           2.1333333333333333`, 0.08813685504191558}, {3.2, 
           0.09307891699488438}, {4.266666666666667, 0.09475786472703854}, {
           5.333333333333333, 0.09539364453420852}, {6.4, 
           0.09564879363745882}, {7.466666666666667, 0.09575403133237946}, {
           8.533333333333333, 0.09579796674120333}, {9.6, 
           0.09581640521408984}, {10.666666666666666`, 0.0958241605224608}, {
           11.733333333333333`, 0.09582742550475977}, {12.8, 
           0.09582880060578526}, {13.866666666666667`, 0.09582937984892477}, {
           14.933333333333334`, 0.09582962386461444}, {16., 
           0.09582972666328074}}]}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6],
           Dashing[{Small, Small}], 
          LineBox[{{0., 0.09582980149734006}, {1.0666666666666667`, 
           0.09582980149734006}, {2.1333333333333333`, 0.09582980149734006}, {
           3.2, 0.09582980149734006}, {4.266666666666667, 
           0.09582980149734006}, {5.333333333333333, 0.09582980149734006}, {
           6.4, 0.09582980149734006}, {7.466666666666667, 
           0.09582980149734006}, {8.533333333333333, 0.09582980149734006}, {
           9.6, 0.09582980149734006}, {10.666666666666666`, 
           0.09582980149734006}, {11.733333333333333`, 0.09582980149734006}, {
           12.8, 0.09582980149734006}, {13.866666666666667`, 
           0.09582980149734006}, {14.933333333333334`, 0.09582980149734006}, {
           16., 0.09582980149734006}}]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"t\"", TraditionalForm], 
         FormBox[
         "\"\[Tau]*\\!\\(\\*SubscriptBox[\\(R\\), \
\\(t\\)]\\)*\\!\\(\\*SubscriptBox[\\(p\\), \\(t\\)]\\)*1000\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{30.000000000000004`, 30.000000000000057`}, {30., 
        30.00000000000003}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 17}, {0, 0.10062121299644478`}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.1], 
          Scaled[0.1]}, {None, 
          Scaled[0.1]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {5, 
           FormBox["5", TraditionalForm]}, {10, 
           FormBox["10", TraditionalForm]}, {15, 
           FormBox["15", TraditionalForm]}}, {{0, 
           FormBox["0", TraditionalForm]}, {0.05, 
           FormBox["0.05`", TraditionalForm]}, {0.1, 
           FormBox["0.1`", TraditionalForm]}}}], {576., -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, {}},
  ImageMargins->0.,
  ImageSize->{
    UpTo[600], 
    UpTo[700]},
  ImageSizeRaw->Automatic,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.773391769626202*^9, 3.773391793762042*^9}, {
   3.773391841886105*^9, 3.773391985472184*^9}, 3.773392022474245*^9, 
   3.7733921395032454`*^9, {3.773392177074353*^9, 3.773392209842802*^9}, 
   3.7733923155087557`*^9, {3.773392420003498*^9, 3.773392491101302*^9}, 
   3.773392557697393*^9, {3.773392597674247*^9, 3.773392601311719*^9}, {
   3.773392643427558*^9, 3.773392681710981*^9}, 3.773392932351762*^9, 
   3.773393033549735*^9, 3.773393091332892*^9, 3.773393133340588*^9, {
   3.773393170266602*^9, 3.773393205600596*^9}, {3.773393271184288*^9, 
   3.773393389519726*^9}, 3.773393537441502*^9, {3.773393575008965*^9, 
   3.773393607127412*^9}, {3.773393666619211*^9, 3.773393686286604*^9}, 
   3.773393730960395*^9, 3.773393765838736*^9, {3.773393860610237*^9, 
   3.773393863018797*^9}, 3.773393965407604*^9, 3.7733940116541653`*^9, 
   3.773394128976985*^9, {3.77339833341124*^9, 3.773398342862626*^9}, 
   3.773398431905654*^9, 3.773398522637501*^9, {3.7733985573458157`*^9, 
   3.773398572492515*^9}, {3.773398603777866*^9, 3.773398629998863*^9}, 
   3.7733986891023397`*^9, 3.773398742413509*^9, 3.7733988047925243`*^9, 
   3.773398855198621*^9, {3.7733989354811907`*^9, 3.7733990114471407`*^9}, 
   3.7733991751778297`*^9, {3.773399228855907*^9, 3.773399239910287*^9}, {
   3.7733992920122128`*^9, 3.7733993591083813`*^9}, {3.7733994337792397`*^9, 
   3.7733994522134666`*^9}, {3.7733995534626713`*^9, 3.77339959683314*^9}, {
   3.773399771810144*^9, 3.7733998112662983`*^9}, 3.77339990289797*^9, {
   3.773399942988337*^9, 3.7733999790777407`*^9}, 3.773424476812518*^9, {
   3.773424620037307*^9, 3.773424678948567*^9}, {3.7734266432590523`*^9, 
   3.77342665313139*^9}, {3.7734267105148373`*^9, 3.7734267213338337`*^9}, {
   3.77342688333604*^9, 3.7734268919309263`*^9}, 3.773426938893503*^9, 
   3.773426976231841*^9, 3.773427031014722*^9, 3.773427075181719*^9, 
   3.773427138980404*^9, 3.773427179815332*^9, 3.773427243724662*^9, 
   3.7740295888922367`*^9, 3.7740296387381897`*^9, 3.774029819521614*^9, 
   3.774029965017909*^9, 3.774030008390291*^9, 3.774030216722499*^9, 
   3.774030310758398*^9, 3.774073779466496*^9, 3.77407388043892*^9, 
   3.7740746162846537`*^9, 3.774084695332624*^9, 3.7740847514970303`*^9, 
   3.774084841024914*^9, 3.77408489660571*^9, 3.774084933698954*^9, 
   3.774085050952712*^9, 3.774085094294588*^9, 3.774085147539171*^9, 
   3.774085196410906*^9, 3.774180940176498*^9, 3.7741810110959997`*^9, 
   3.774181121853771*^9, 3.7741811605998287`*^9, 3.774181254027471*^9, 
   3.7741814305714207`*^9, 3.774181540477062*^9, 3.774181623890814*^9, {
   3.774181656426817*^9, 3.774181685535788*^9}, 3.774181782287155*^9, 
   3.774181969868803*^9, {3.7741821449291487`*^9, 3.774182163261147*^9}, 
   3.7741822191619987`*^9, 3.774182380774057*^9, 3.774230469905655*^9, 
   3.774230919718533*^9, 3.77423108210256*^9, 3.774231161154922*^9, 
   3.7742312257166147`*^9, 3.774231362721113*^9, 3.7742314398363867`*^9, 
   3.774231645731565*^9, 3.774231871054237*^9, 3.774231941398281*^9, 
   3.774232076937579*^9, 3.774232122354452*^9, 3.7742321638880377`*^9, 
   3.7742322097049427`*^9, 3.774232266325796*^9, 3.7742323224891233`*^9, 
   3.774232408185298*^9, 3.774232606719839*^9, 3.7742326734873257`*^9, 
   3.774232820420686*^9, {3.774237916247855*^9, 3.7742379656635513`*^9}, {
   3.774237996640263*^9, 3.7742380106863823`*^9}, 3.774238100430128*^9, 
   3.7742381644434767`*^9, 3.7742382130772057`*^9, 3.774238497887093*^9, 
   3.7742385666437597`*^9, 3.77423861081085*^9, 3.7742428658828783`*^9, 
   3.77424298921434*^9, 3.774243073265023*^9, 3.7742431880851307`*^9, 
   3.7742432301659603`*^9, 3.774243337039177*^9, 3.7742433868585663`*^9, 
   3.774243446344429*^9, {3.774243488868875*^9, 3.774243521375247*^9}, 
   3.774243574623087*^9, 3.774243839438405*^9, {3.774243917258606*^9, 
   3.7742439337566442`*^9}, 3.77424409489393*^9, 3.7742441519360027`*^9, 
   3.774244358831924*^9, 3.7742473594520683`*^9, 3.774247429690049*^9, {
   3.774251073973688*^9, 3.774251100447418*^9}, 3.7742511508793583`*^9, 
   3.7742526788331633`*^9, 3.774252738180696*^9, 3.7742534942208157`*^9, 
   3.774268752671775*^9, 3.774268825260709*^9, 3.774268901492374*^9, 
   3.774348566065023*^9, {3.7743486584136066`*^9, 3.774348710404612*^9}, 
   3.774348880682391*^9, 3.774348961358797*^9, {3.774349012540594*^9, 
   3.774349033876733*^9}, 3.774349071955331*^9, 3.774349105096806*^9, 
   3.774606592628628*^9, 3.774606693053277*^9, 3.774606752364154*^9, 
   3.774606975201962*^9, 3.7746073090585213`*^9, 3.774607448878001*^9, {
   3.774607501929043*^9, 3.77460752765597*^9}, 3.774607563315156*^9, 
   3.774608093691485*^9, 3.774608341466749*^9, {3.7746083939097853`*^9, 
   3.7746084145749702`*^9}, 3.774608454794455*^9, 3.7746084897048273`*^9, 
   3.774608532263989*^9, {3.774608576972452*^9, 3.774608597237276*^9}, {
   3.7746086672408752`*^9, 3.774608695776314*^9}, 3.774608814159079*^9, 
   3.7746089178710957`*^9, {3.7746089779230556`*^9, 3.774609015010668*^9}, {
   3.774609155332431*^9, 3.774609213348015*^9}, 3.7746099740667677`*^9, 
   3.774688555039424*^9, 3.774688849385157*^9, 3.7746889030597057`*^9, 
   3.7746890245043087`*^9, 3.7746890781690273`*^9, 3.774689190952766*^9, {
   3.774689262279601*^9, 3.774689286173368*^9}, 3.7746893566664553`*^9, 
   3.774689398590653*^9, {3.774689455622992*^9, 3.774689481230742*^9}, 
   3.774689542685972*^9, {3.7746896106915817`*^9, 3.774689624363495*^9}, 
   3.7746901855051527`*^9, {3.774690217865737*^9, 3.774690234589903*^9}, 
   3.774690278114019*^9, 3.778903432076002*^9, 3.778903477648535*^9, 
   3.7789035076975813`*^9, 3.780761684609508*^9, {3.7808048934746943`*^9, 
   3.7808049009134007`*^9}, 3.781697245413604*^9, 3.7818596773449087`*^9, 
   3.8544317362800283`*^9},
 CellLabel->
  "Out[626]=",ExpressionUUID->"82af3dc7-f825-4ef4-b431-a1c4f87757d7"]
}, Open  ]]
},
WindowSize->{1280, 674},
WindowMargins->{{16, Automatic}, {Automatic, 52}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0fd27a19-9d45-4c1d-bca2-a7a67bdbef43"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 633, 14, 67, "Input",ExpressionUUID->"128e60b1-37e0-4738-bf2f-1069d9251759"],
Cell[CellGroupData[{
Cell[1216, 38, 34931, 788, 3591, "Input",ExpressionUUID->"4ca19a78-2b0f-451e-948e-1e1529dbd2a6"],
Cell[36150, 828, 5898, 82, 34, "Output",ExpressionUUID->"89a3631b-a4f7-4580-90f8-9eae09e687a3"],
Cell[42051, 912, 6460, 93, 34, "Output",ExpressionUUID->"58ee7a81-cf3f-4fd3-85e2-51cf273707a3"],
Cell[48514, 1007, 6035, 84, 38, "Output",ExpressionUUID->"32d6975b-c1b6-4a52-a69d-d3605cca503b"],
Cell[54552, 1093, 7926, 144, 304, "Output",ExpressionUUID->"a2c3752c-7154-4e47-953e-c969dc8d0685"],
Cell[62481, 1239, 6224, 87, 51, "Output",ExpressionUUID->"20272971-2f8e-4f5c-b469-1da859440e0f"],
Cell[68708, 1328, 8852, 132, 300, "Output",ExpressionUUID->"027212ea-bc0f-4dbb-8e16-61e71f2bca42"],
Cell[77563, 1462, 9195, 160, 377, "Output",ExpressionUUID->"38e77eec-8fbd-46a0-bbee-a730a9e6a376"],
Cell[86761, 1624, 9131, 157, 377, "Output",ExpressionUUID->"7afc2553-f867-4b20-b715-62ecb9b2df43"],
Cell[95895, 1783, 9020, 156, 377, "Output",ExpressionUUID->"7238622e-27f4-4ba5-af87-e8755b0b82a3"],
Cell[104918, 1941, 9154, 159, 377, "Output",ExpressionUUID->"717b00ff-2ad0-45fd-ba66-9e9382c12c9c"],
Cell[114075, 2102, 9058, 157, 377, "Output",ExpressionUUID->"40f866ef-ddf3-4d97-bab2-522e96899564"],
Cell[123136, 2261, 9078, 158, 377, "Output",ExpressionUUID->"1b0b21d3-0b4e-45ab-bf90-89e22efe976d"],
Cell[132217, 2421, 28103, 549, 717, "Output",ExpressionUUID->"82af3dc7-f825-4ef4-b431-a1c4f87757d7"]
}, Open  ]]
}
]
*)

