(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    313947,       6315]
NotebookOptionsPosition[    311764,       6281]
NotebookOutlinePosition[    312162,       6297]
CellTagsIndexPosition[    312119,       6294]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.769155249292598*^9, 3.769155478823312*^9}, {
  3.7691555711283903`*^9, 3.76915559150035*^9}, {3.76915643281081*^9, 
  3.769156558536229*^9}, {3.769156675827311*^9, 3.769156676039103*^9}, {
  3.769157054313663*^9, 3.7691570571144953`*^9}, {3.7729954274886217`*^9, 
  3.772995429032259*^9}},
 FontSize->18,
 CellLabel->
  "In[692]:=",ExpressionUUID->"128e60b1-37e0-4738-bf2f-1069d9251759"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Gasteiger", " ", "and", " ", "Prettner", " ", 
    RowBox[{"(", 
     RowBox[{"2022", ",", 
      RowBox[{"p", ".233"}], ",", 
      RowBox[{
       RowBox[{"Figures", " ", "4"}], "-", "5"}]}], ")"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Last", " ", 
     RowBox[{"checked", ":", " ", 
      RowBox[{"February", " ", "21", "st"}]}]}], ",", "2022"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"IMPORTANT", ":", " ", 
    RowBox[{
    "evaluate", " ", "22", "_MD", "_gasteiger", "_prettner", "_generalized", 
     "_linearized", 
     RowBox[{"_modules", ".", "nb"}], " ", "befure", " ", "using", " ", 
     "this"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"List", " ", "of", " ", "parameters"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "=", 
     RowBox[{"1", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", 
     RowBox[{"0.98", "^", "25"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "0.009"}], ")"}], "^", "25"}], ")"}], "-", "1"}]}],
     ";", " ", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"World", " ", "Bank", " ", 
         RowBox[{"(", 
          RowBox[{"2019", "a"}], ")"}]}], "\[CloseCurlyQuote]"}], "s", " ", 
       "World", " ", "Development", " ", "Indicators"}], ",", " ", 
      RowBox[{
       RowBox[{"average", " ", "over", " ", "1970"}], "-", 
       RowBox[{
       "2017", " ", "suggest", " ", "a", " ", "value", " ", "of", " ", "0.9", 
        "%"}]}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Mu]", "=", "0.50"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1", "-", "\[Mu]"}]], " ", "=", " ", 
      RowBox[{"2", " ", "following", " ", "De", " ", "Canio", " ", 
       RowBox[{"(", 
        RowBox[{"2016", ",", "JMacro"}], ")"}], " ", "paper"}]}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{"\[Nu]", "=", "0.10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "rather", " ", "low", " ", "share", " ", "of", " ", "robots", " ", "in", 
      " ", "production"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Theta]", "=", "2.00"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"range", " ", "suggested", " ", "by", " ", "Guvenen", " ", 
      RowBox[{"(", 
       RowBox[{"2006", ",", "JME"}], ")"}], " ", "und", " ", "Chetty", " ", 
      RowBox[{"(", 
       RowBox[{"2006", ",", "AER"}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Tau]", "=", "0.00"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Considered", " ", "values", " ", "for", " ", "\[Tau]"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]min", "=", "0.00"}], ";", 
    RowBox[{"\[Tau]max", "=", "4.0"}], ";", 
    RowBox[{"d\[Tau]", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]list", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"\[Tau]", ",", 
       RowBox[{"{", 
        RowBox[{
        "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
        "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"scale", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Steady", " ", 
      RowBox[{"states", ":", " ", "k"}]}], ",", " ", "p", ",", " ", "w", ",", 
     " ", "R", ",", " ", "y", ",", " ", 
     RowBox[{"\[Tau]", "*", "R", "*", "p"}], ",", " ", "c1", ",", " ", "c2"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ksslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"kss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"pss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wsslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"wss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rsslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Rss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "/", "100"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ysslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"yss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"revlist", "=", " ", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"revss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "1000"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c1sslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"c1ss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2sslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"c2ss", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"savesslist", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"savess", "/.", 
         RowBox[{"SteadyP", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", 
           ",", "\[Theta]", ",", "\[Tau]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Tau]", ",", "\[Tau]min", ",", "\[Tau]max", ",", "d\[Tau]"}], 
         "}"}]}], "]"}], "*", "scale"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Compute", " ", "the", " ", "xlist1", " ", "to", " ", "express", " ", 
     "the", " ", "welfare", " ", "measure", " ", "in", " ", "units", " ", 
     "of", " ", "consumption", " ", "when", " ", "YOUNG", "\"\< \>"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xlist1", "=", 
     RowBox[{
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"c1sslist", "[", 
             RowBox[{"[", "1", "]"}], "]"}], 
            RowBox[{"1", "-", "\[Theta]"}]], "+", 
           RowBox[{"\[Beta]", "*", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"c2sslist", "[", 
                RowBox[{"[", "1", "]"}], "]"}], 
               RowBox[{"1", "-", "\[Theta]"}]], "-", 
              SuperscriptBox[
               RowBox[{"c2sslist", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ";;", 
                  RowBox[{
                   RowBox[{"Dimensions", "[", "c2sslist", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], 
               RowBox[{"1", "-", "\[Theta]"}]]}], ")"}]}]}], 
          SuperscriptBox[
           RowBox[{"c1sslist", "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{
               RowBox[{"Dimensions", "[", "c1sslist", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], 
           RowBox[{"1", "-", "\[Theta]"}]]], ")"}], 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Theta]"}], ")"}]}]], ")"}], "-", "1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Compute", " ", "the", " ", "xlist2", " ", "to", " ", "express", " ", 
     "the", " ", "welfare", " ", "measure", " ", "in", " ", "units", " ", 
     "of", " ", "consumption", " ", "when", " ", "OLD", "\"\< \>"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xlist2", "=", 
     RowBox[{
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"c1sslist", "[", 
                RowBox[{"[", "1", "]"}], "]"}], 
               RowBox[{"1", "-", "\[Theta]"}]], " ", "-", " ", 
              SuperscriptBox[
               RowBox[{"c1sslist", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ";;", 
                  RowBox[{
                   RowBox[{"Dimensions", "[", "c1sslist", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], 
               RowBox[{"1", "-", "\[Theta]"}]]}], ")"}], "/", "\[Beta]"}], 
           "+", 
           SuperscriptBox[
            RowBox[{"c2sslist", "[", 
             RowBox[{"[", "1", "]"}], "]"}], 
            RowBox[{"1", "-", "\[Theta]"}]]}], 
          SuperscriptBox[
           RowBox[{"c2sslist", "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{
               RowBox[{"Dimensions", "[", "c2sslist", "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], 
           RowBox[{"1", "-", "\[Theta]"}]]], ")"}], 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Theta]"}], ")"}]}]], ")"}], "-", "1"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Consumption", " ", "equivalent", " ", "1"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CElist1", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"xlist1", "*", "c1sslist"}], ")"}], "/", "ysslist"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tauMin1", "=", 
     RowBox[{"\[Tau]list", "[", 
      RowBox[{"[", 
       RowBox[{"Ordering", "[", 
        RowBox[{
         RowBox[{"CElist1", "*", "100"}], ",", "1"}], "]"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tauMinVal1", "=", 
     RowBox[{"Min", "[", 
      RowBox[{"CElist1", "*", "100"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"tauZero1", "=", 
     RowBox[{"\[Tau]list", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{
          RowBox[{"Sign", "[", 
           RowBox[{"CElist1", "*", "100"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{"Sign", "[", 
            RowBox[{"CElist1", "*", "100"}], "]"}], "]"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tauZeroVal1", "=", 
     RowBox[{
      RowBox[{"CElist1", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{
           RowBox[{"Sign", "[", 
            RowBox[{"CElist1", "*", "100"}], "]"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"Sign", "[", 
             RowBox[{"CElist1", "*", "100"}], "]"}], "]"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "*", "100"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Consumption", " ", "equivalent", " ", "2"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CElist2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"xlist2", "*", "c2sslist"}], ")"}], "/", "ysslist"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tauMin2", "=", 
     RowBox[{"\[Tau]list", "[", 
      RowBox[{"[", 
       RowBox[{"Ordering", "[", 
        RowBox[{
         RowBox[{"CElist2", "*", "100"}], ",", "1"}], "]"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tauMinVal2", "=", 
     RowBox[{"Min", "[", 
      RowBox[{"CElist2", "*", "100"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"tauZero2", "=", 
     RowBox[{"\[Tau]list", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{
          RowBox[{"Sign", "[", 
           RowBox[{"CElist2", "*", "100"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{"Sign", "[", 
            RowBox[{"CElist2", "*", "100"}], "]"}], "]"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tauZeroVal2", "=", 
     RowBox[{
      RowBox[{"CElist2", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{
           RowBox[{"Sign", "[", 
            RowBox[{"CElist2", "*", "100"}], "]"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"Sign", "[", 
             RowBox[{"CElist2", "*", "100"}], "]"}], "]"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "*", "100"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\"\<\[Tau]'s that minimize CE1 and CE2 and \[Tau]'s where CE1 and CE2 \
become positive\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tauMin1", ",", "tauMinVal1"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"tauMin2", ",", "tauMinVal2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"tauZero1", ",", "tauZeroVal1"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"tauZero2", ",", "tauZeroVal2"}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "//", "MatrixForm"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Just", " ", "for", " ", "plotting"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineStyle", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Dotted", ",", "Gray"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\"\<Plots of kss, pss, wss, Rss, yss, CE\>\"", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"padding", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "25"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"kssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "ksslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "ksslist", "]"}], ",", 
           RowBox[{"Max", "[", "ksslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(k\), \(ss\)]\)\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "ksslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "ksslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "ksslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "ksslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "ksslist", "]"}]}], "}"}]}], "}"}], "]"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_kss.pdf\>\"", ",",
       "kssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"pssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "psslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"Max", "[", "psslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(p\), \(ss\)]\)\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "psslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "psslist", "]"}]}], "}"}]}], "}"}], "]"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_pss.pdf\>\"", ",",
       "pssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"wssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "wsslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "wsslist", "]"}], ",", 
           RowBox[{"Max", "[", "wsslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(w\), \(ss\)]\)\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "wsslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "wsslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "wsslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "wsslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "wsslist", "]"}]}], "}"}]}], "}"}], "]"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_wss.pdf\>\"", ",",
       "wssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Rssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "Rsslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "Rsslist", "]"}], ",", 
           RowBox[{"Max", "[", "Rsslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(R\), \(ss\)]\)/100\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "Rsslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "Rsslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "Rsslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "Rsslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "Rsslist", "]"}]}], "}"}]}], "}"}], "]"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_Rss.pdf\>\"", ",",
       "Rssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"yssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "ysslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "ysslist", "]"}], ",", 
           RowBox[{"Max", "[", "ysslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(y\), \(ss\)]\)\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "ysslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "ysslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "ysslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "ysslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "ysslist", "]"}]}], "}"}]}], "}"}], "]"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_yss.pdf\>\"", ",",
       "yssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"revplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "revlist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"Max", "[", "revlist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(\[Tau]\), \(ss\)]\)*1000\>\""}], "}"}]}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "revlist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "revlist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "revlist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "revlist", "]"}]}], "}"}]}], "}"}], "]"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_revss.pdf\>\"", 
      ",", "revplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"savessplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "savesslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "savesslist", "]"}], ",", 
           RowBox[{"Max", "[", "savesslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(s\), \(ss\)]\)\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "savesslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "savesslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "savesslist", "]"}]}], "}"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "savesslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "savesslist", "]"}]}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_sss.pdf\>\"", ",",
       "savessplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"c1ssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "c1sslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "c1sslist", "]"}], ",", 
           RowBox[{"Max", "[", "c1sslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*TemplateBox[{\"c\", \"1\", \
\"ss\"},\"Subsuperscript\"]\)\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "c1sslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "c1sslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "c1sslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "c1sslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "c1sslist", "]"}]}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_c1ss.pdf\>\"", 
      ",", "c1ssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"c2ssplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "c2sslist", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", "c2sslist", "]"}], ",", 
           RowBox[{"Max", "[", "c2sslist", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Tau]\>\"", ",", 
         "\"\<\!\(\*TemplateBox[{\"c\", \"2\", \
\"ss\"},\"Subsuperscript\"]\)\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Min", "[", "c2sslist", "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "14"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "c2sslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "c2sslist", "]"}]}], "}"}]}], "}"}], "]"}], 
         ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Min", "[", "c2sslist", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"Max", "[", "c2sslist", "]"}]}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_fig_levels_TAXES_c2ss.pdf\>\"", 
      ",", "c2ssplot"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"CEplot", "=", 
    RowBox[{"ListLinePlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"CElist1", "*", "100"}], ",", 
        RowBox[{"CElist2", "*", "100"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Tau]min", "-", "d\[Tau]"}], ",", 
           RowBox[{"\[Tau]max", "+", "d\[Tau]"}]}], "}"}], ",", "Automatic"}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[Tau]min", ",", "\[Tau]max"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<%\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "0.03", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
         "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "12"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", "Dashed", ",", "12"}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{
         RowBox[{"LineLegend", "[", 
          RowBox[{"Automatic", ",", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*FractionBox[\(\*SubscriptBox[\(x\), \
\(1\)]*\*SubscriptBox[\(c\), \(1, \[Tau]\)]\), SubscriptBox[\(y\), \
\(\[Tau]\)]]\)*100\>\"", ",", 
             "\"\<\!\(\*FractionBox[\(\*SubscriptBox[\(x\), \
\(2\)]*\*SubscriptBox[\(c\), \(2, \[Tau]\)]\), SubscriptBox[\(y\), \
\(\[Tau]\)]]\)*100\>\""}], "}"}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<Row\>\"", ",", "2"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.75", ",", "0.30"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", "lineStyle", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"-", "0.10"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauMin1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "0.10"}], "}"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"-", "0.10"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"tauZero1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "0.10"}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", 
       RowBox[{"Scaled", "[", ".2", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "padding"}]}], "\[IndentingNewLine]",
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_tax_CE.pdf\>\"", ",", "CEplot"}], 
     "]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{"CEplot", ",", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<0\>\"", ",", "Black", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.10"}], ",", "0.002"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<./figures/generalized_linearized_tax_CE.pdf\>\"", ",", "%"}],
     "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Combine", " ", "plots"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Plottax", "=", 
    RowBox[{"GraphicsGrid", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"pssplot", ",", "kssplot", ",", "yssplot"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"wssplot", ",", "Rssplot", ",", "revplot"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"savessplot", ",", "c1ssplot", ",", "c2ssplot"}], "}"}]}], 
       "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", "Center"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<./figures/generalized_linearized_tax_analysis.pdf\>\"", ",", 
      "Plottax"}], "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "n", ",", "\[Mu]", ",", "\[Nu]", ",", 
     "\[Theta]", ",", "\[Tau]", ",", "\[Tau]list", ",", "\[Tau]min", ",", 
     "\[Tau]max", ",", "d\[Tau]", ",", "scale", ",", "ksslist", ",", 
     "psslist", ",", "wsslist", ",", "Rsslist", ",", "ysslist", ",", 
     "revlist", ",", "c1sslist", ",", "c2sslist", ",", "savesslist", ",", 
     "xlist1", ",", "xlist2", ",", "CElist1", ",", "CElist2", ",", "tauMin1", 
     ",", "tauMinVal1", ",", "tauMin2", ",", "tauMinVal2", ",", "tauZero1", 
     ",", "tauZeroVal1", ",", "tauZero2", ",", "tauZeroVal2", ",", "kssplot", 
     ",", "pssplot", ",", "wssplot", ",", "Rssplot", ",", "yssplot", ",", 
     "revplot", ",", "savessplot", ",", "c1ssplot", ",", "c2ssplot", ",", 
     "Plottax", ",", "CEplot", ",", "lineStyle"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.774253148226068*^9, 3.774253233959495*^9}, {
   3.774253293756308*^9, 3.774253296594255*^9}, {3.774253341059441*^9, 
   3.774253384136278*^9}, {3.7742534599252*^9, 3.774253460402656*^9}, {
   3.7742670598917294`*^9, 3.774267085776869*^9}, {3.77426711974568*^9, 
   3.774267166784232*^9}, {3.774267209678259*^9, 3.7742673134795732`*^9}, {
   3.7742673697834063`*^9, 3.774267378367023*^9}, {3.7742674246848383`*^9, 
   3.774267585259775*^9}, {3.77426762318804*^9, 3.77426789567829*^9}, {
   3.774267931263564*^9, 3.774267960093256*^9}, {3.774267992980633*^9, 
   3.774268116770878*^9}, {3.774268160485435*^9, 3.774268225237733*^9}, {
   3.774268266120613*^9, 3.774268272341823*^9}, 3.7742683063187943`*^9, {
   3.774268374356463*^9, 3.774268392603533*^9}, {3.77426842884883*^9, 
   3.7742685335288877`*^9}, {3.7742685662349653`*^9, 3.774268629566368*^9}, {
   3.774268662955847*^9, 3.774268676449354*^9}, {3.77434914409905*^9, 
   3.774349164793048*^9}, {3.7746070493680573`*^9, 3.7746070869496183`*^9}, {
   3.774607177689883*^9, 3.7746071791596823`*^9}, 3.774609515362574*^9, {
   3.774609548260508*^9, 3.774609549944318*^9}, {3.774609757921732*^9, 
   3.7746097593988523`*^9}, {3.7746097990474033`*^9, 3.774609800237446*^9}, {
   3.774609847869856*^9, 3.774609917226542*^9}, {3.776584726275002*^9, 
   3.776584764008757*^9}, 3.776584912518066*^9, {3.776584946566648*^9, 
   3.776585096421763*^9}, {3.776585131780848*^9, 3.77658533732321*^9}, {
   3.776585387706153*^9, 3.776585550345628*^9}, {3.776585592915304*^9, 
   3.776585593336302*^9}, {3.776585652302175*^9, 3.7765857691122313`*^9}, {
   3.776585819678748*^9, 3.776585831435029*^9}, {3.7765858825484447`*^9, 
   3.7765859209190893`*^9}, {3.7765860566374474`*^9, 3.776586101584015*^9}, {
   3.776586135347863*^9, 3.7765861818541822`*^9}, {3.776586216469329*^9, 
   3.776586221916589*^9}, {3.776586254498632*^9, 3.776586386772769*^9}, {
   3.776586487483673*^9, 3.776586490264299*^9}, {3.7765865890718718`*^9, 
   3.776586612960558*^9}, {3.776586721054744*^9, 3.77658672476684*^9}, {
   3.7765871039237223`*^9, 3.776587104179124*^9}, {3.776587267063801*^9, 
   3.7765873050669537`*^9}, {3.776587337888988*^9, 3.776587345841105*^9}, {
   3.776587544195519*^9, 3.776587549767209*^9}, 3.7766463913182087`*^9, {
   3.776646436003388*^9, 3.7766464410034523`*^9}, {3.7766466207637663`*^9, 
   3.776646630879661*^9}, {3.776647882779888*^9, 3.776647925109963*^9}, {
   3.7768645328712587`*^9, 3.77686459250298*^9}, {3.776864635575952*^9, 
   3.7768646482625933`*^9}, {3.776864757966488*^9, 3.776864819594739*^9}, {
   3.7768648551578217`*^9, 3.776864864236487*^9}, {3.776864896302717*^9, 
   3.776865031052429*^9}, {3.776865070549611*^9, 3.776865087883757*^9}, {
   3.776865121652463*^9, 3.776865121750078*^9}, {3.776865160418745*^9, 
   3.776865214637147*^9}, 3.7768652523412943`*^9, {3.77686528497576*^9, 
   3.776865313546331*^9}, {3.776865355464629*^9, 3.776865373409458*^9}, {
   3.776865444379087*^9, 3.776865549525299*^9}, {3.7768660898129263`*^9, 
   3.776866265537449*^9}, {3.7768664147632523`*^9, 3.776866510539077*^9}, {
   3.7768665750660133`*^9, 3.7768666056807537`*^9}, {3.776866677858499*^9, 
   3.776866689631468*^9}, {3.7768667464569817`*^9, 3.776866776610364*^9}, {
   3.7768668735745697`*^9, 3.776866932896151*^9}, {3.77686698132025*^9, 
   3.776866982404944*^9}, {3.776867119982987*^9, 3.7768671427822037`*^9}, {
   3.7768671764484177`*^9, 3.776867195906878*^9}, {3.776867903301071*^9, 
   3.7768679791795073`*^9}, {3.7768680456619596`*^9, 3.776868050244162*^9}, {
   3.776868108540245*^9, 3.776868118071209*^9}, {3.7768682063940268`*^9, 
   3.776868277955968*^9}, {3.7768683551770487`*^9, 3.776868372484708*^9}, {
   3.7783442764447727`*^9, 3.778344281067671*^9}, {3.7783443861583767`*^9, 
   3.7783444127772293`*^9}, {3.7783444670776253`*^9, 3.778344485418371*^9}, {
   3.778344523458753*^9, 3.778344528740675*^9}, {3.778344662198682*^9, 
   3.77834466843783*^9}, {3.778344724526312*^9, 3.7783447261828747`*^9}, {
   3.778344771823618*^9, 3.7783447798964043`*^9}, {3.7783448266767893`*^9, 
   3.7783448378422737`*^9}, {3.778345714272793*^9, 3.77834574639293*^9}, {
   3.778345967528751*^9, 3.778346117507928*^9}, {3.7783461854171963`*^9, 
   3.778346209437788*^9}, {3.778346251972739*^9, 3.7783462702261057`*^9}, {
   3.778346308786784*^9, 3.778346347324997*^9}, {3.7783464125854073`*^9, 
   3.778346451050728*^9}, 3.778346507894761*^9, {3.77834654877334*^9, 
   3.778346553066424*^9}, 3.778346591157422*^9, {3.778347150398794*^9, 
   3.7783472113751783`*^9}, {3.778347395478243*^9, 3.778347404822083*^9}, {
   3.77834747848283*^9, 3.778347507870852*^9}, {3.7783475457225847`*^9, 
   3.778347602951345*^9}, {3.7783476407980833`*^9, 3.7783477236278543`*^9}, {
   3.7783477981943417`*^9, 3.7783478384519567`*^9}, {3.778348009085368*^9, 
   3.778348083467144*^9}, 3.778387096370172*^9, {3.7783880474761553`*^9, 
   3.7783880741642323`*^9}, {3.77838826342715*^9, 3.778388265534976*^9}, {
   3.778388358727296*^9, 3.7783883591708517`*^9}, {3.778389112972508*^9, 
   3.778389133113871*^9}, {3.7783892073131657`*^9, 3.778389207422124*^9}, 
   3.778389307724434*^9, 3.778389368649666*^9, {3.778389433561406*^9, 
   3.778389433619164*^9}, {3.778389705019124*^9, 3.778389731173133*^9}, 
   3.778389776919829*^9, {3.7783898721628857`*^9, 3.778389888084882*^9}, 
   3.7783899197993517`*^9, 3.778389966390999*^9, {3.778389999429908*^9, 
   3.77839001447885*^9}, {3.77839010876866*^9, 3.778390126227524*^9}, {
   3.778390168581764*^9, 3.7783902136399*^9}, {3.7783903068356333`*^9, 
   3.778390350432416*^9}, 3.77839040077745*^9, {3.778390446095752*^9, 
   3.778390487109271*^9}, {3.778390521139056*^9, 3.778390528472682*^9}, {
   3.778390558946268*^9, 3.778390716656502*^9}, {3.778391142607546*^9, 
   3.778391143757032*^9}, 3.778391220259778*^9, 3.778827590144088*^9, {
   3.778827803602639*^9, 3.7788278577999268`*^9}, {3.778827908894926*^9, 
   3.778827947245121*^9}, {3.778828006613928*^9, 3.778828038011146*^9}, {
   3.7788281719673977`*^9, 3.77882817373382*^9}, {3.778828266473309*^9, 
   3.778828266561604*^9}, {3.7788283280236597`*^9, 3.778828330478702*^9}, {
   3.778828402075967*^9, 3.778828414756118*^9}, {3.778828458442505*^9, 
   3.778828461680172*^9}, {3.7788284945757236`*^9, 3.778828498999818*^9}, {
   3.778828557446207*^9, 3.778828661552198*^9}, {3.778828707145217*^9, 
   3.778828807347883*^9}, {3.778828840795157*^9, 3.778828840839634*^9}, {
   3.77882887349631*^9, 3.778828874694166*^9}, {3.778828915838974*^9, 
   3.778828956901082*^9}, {3.780804952692124*^9, 3.78080495286078*^9}, {
   3.780805028818722*^9, 3.780805028961652*^9}, {3.78080507970002*^9, 
   3.7808051066013527`*^9}, {3.780805454745968*^9, 3.7808054550424356`*^9}, {
   3.7808055040712967`*^9, 3.780805507023672*^9}, {3.7808055573745337`*^9, 
   3.780805586972402*^9}, {3.780805631475383*^9, 3.780805661728424*^9}, 
   3.780805695593947*^9, {3.7808057535088053`*^9, 3.78080578390035*^9}, {
   3.7808058444517603`*^9, 3.7808058528645477`*^9}, {3.780805888073135*^9, 
   3.7808058984953823`*^9}, {3.780805942566416*^9, 3.780806042654188*^9}, {
   3.780806079558262*^9, 3.7808061068198967`*^9}, {3.7808061570163517`*^9, 
   3.7808061787121162`*^9}, {3.7808062573037043`*^9, 3.780806273991481*^9}, {
   3.7808063164694777`*^9, 3.780806396519267*^9}, {3.780806456405302*^9, 
   3.780806472101716*^9}, {3.780806530819943*^9, 3.780806549482826*^9}, {
   3.7808071176647053`*^9, 3.780807118325791*^9}, 3.780807180310501*^9, {
   3.780807211196745*^9, 3.780807231861858*^9}, {3.7808506816381903`*^9, 
   3.780850690274078*^9}, {3.780850741750736*^9, 3.7808508002790337`*^9}, {
   3.7808508319231586`*^9, 3.7808508353117027`*^9}, {3.7808508657629147`*^9, 
   3.78085089925578*^9}, {3.7808509685962276`*^9, 3.780850994060069*^9}, {
   3.780851209111211*^9, 3.780851218807168*^9}, {3.780851341621993*^9, 
   3.780851369734126*^9}, {3.780851452580488*^9, 3.780851464935383*^9}, 
   3.780851497023402*^9, {3.7808515333693857`*^9, 3.780851587365121*^9}, {
   3.780851631437379*^9, 3.780851644387506*^9}, {3.7808517084423733`*^9, 
   3.780851733257148*^9}, {3.780851831794631*^9, 3.7808518529843473`*^9}, 
   3.780851895399962*^9, {3.780851953666806*^9, 3.780852053604184*^9}, {
   3.780852108571067*^9, 3.780852108678029*^9}, {3.780852151153754*^9, 
   3.7808521992773848`*^9}, {3.780852298314485*^9, 3.780852309477004*^9}, {
   3.780852354491046*^9, 3.780852356963747*^9}, {3.780852417649015*^9, 
   3.780852426607767*^9}, {3.780852476687519*^9, 3.7808524934094877`*^9}, {
   3.780852524657131*^9, 3.780852633351973*^9}, {3.780852774820118*^9, 
   3.780852824936351*^9}, {3.78085300201369*^9, 3.780853034576393*^9}, {
   3.780853114493268*^9, 3.780853227845718*^9}, {3.780853259904007*^9, 
   3.780853297905225*^9}, {3.7814311040161667`*^9, 3.781431106212707*^9}, {
   3.7814311585014143`*^9, 3.781431159538288*^9}, {3.7814311928887873`*^9, 
   3.7814312150396137`*^9}, 3.781431248670594*^9, 3.781431419006383*^9, {
   3.781431470284368*^9, 3.781431485907104*^9}, {3.781431562388299*^9, 
   3.7814315865771303`*^9}, 3.781431692658746*^9, 3.781431723385004*^9, 
   3.7816948673288527`*^9, {3.78169497080044*^9, 3.781694972078043*^9}, {
   3.781695016958447*^9, 3.781695025116424*^9}, {3.781695156216322*^9, 
   3.781695157164826*^9}, {3.78169530818583*^9, 3.781695316887233*^9}, {
   3.7816953625207453`*^9, 3.78169541600896*^9}, {3.7816957275298862`*^9, 
   3.781695769183732*^9}, {3.781695911986924*^9, 3.781695918208806*^9}, {
   3.781698175139826*^9, 3.7816982632576513`*^9}, {3.7816992959795322`*^9, 
   3.7816993297174597`*^9}, {3.781699393137368*^9, 3.7816994142484283`*^9}, {
   3.7818597503029947`*^9, 3.781859805537566*^9}, {3.781859838259494*^9, 
   3.781859894006887*^9}, {3.781860010247909*^9, 3.781860011616426*^9}, {
   3.781860049871725*^9, 3.781860084612715*^9}, {3.781860133482942*^9, 
   3.781860156449885*^9}, {3.781860189274062*^9, 3.781860299778352*^9}, {
   3.781860376962161*^9, 3.7818603833267317`*^9}, 3.8544318837663603`*^9, {
   3.854431916023198*^9, 3.854431919462747*^9}, {3.8544320024531*^9, 
   3.854432034924287*^9}, {3.85443215366998*^9, 3.854432209442415*^9}, 
   3.854432288401586*^9, 
   3.854433047698312*^9},ExpressionUUID->"c08e9d99-428a-4ea4-aab2-\
4bcb0204077d"],

Cell[BoxData["\<\"\[Tau]'s that minimize CE1 and CE2 and \[Tau]'s where CE1 \
and CE2 become positive\"\>"], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432292986198*^9},
 CellLabel->
  "Out[788]=",ExpressionUUID->"d2d23976-c510-41c3-8ea0-382bc6e2cc69"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", "0.55`", "}"}], 
      RowBox[{"-", "0.023085500175221242`"}]},
     {
      RowBox[{"{", "0.55`", "}"}], 
      RowBox[{"-", "0.03853322572223259`"}]},
     {
      RowBox[{"{", "2.43`", "}"}], 
      RowBox[{"{", "0.000085622454530099`", "}"}]},
     {
      RowBox[{"{", "2.43`", "}"}], 
      RowBox[{"{", "0.00014260229250114817`", "}"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432292987735*^9},
 CellLabel->
  "Out[789]//MatrixForm=",ExpressionUUID->"3ce3d44f-4ef4-4c61-8d72-\
8decbd484800"],

Cell[BoxData["\<\"Plots of kss, pss, wss, Rss, yss, CE\"\>"], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.85443229298882*^9},
 CellLabel->
  "Out[791]=",ExpressionUUID->"ed2fed6d-8b14-412a-9f12-c5315a8874c9"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91XlcDPgbB/CpaWpmamZoI2e7KFfOsqyr51lnYiXrWIldOXatXZslVi1Z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      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(k\\), \\(ss\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.0720174143522766},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.0720174143522766}, {0.55, 0.07261659594211733}}], 
    LineBox[{{2.43, 0.0720174143522766}, {2.43, 0.07261659594211733}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.0720174143522766, 0.07261659594211733}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.8544322930123453`*^9},
 CellLabel->
  "Out[793]=",ExpressionUUID->"6ee09212-9812-4f63-a9c2-4988cbf2dbd5"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw113lczfn3B/C737pLhUrKUomKIrKm7jmWSGYsUbYaosXI4Dd2yZIMIzvZ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      
      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(p\\), \\(ss\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0}, {0.55, 0.0002552169968249995}}], 
    LineBox[{{2.43, 0}, {2.43, 0.0002552169968249995}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0, 0.0002552169968249995}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.8544322931818438`*^9},
 CellLabel->
  "Out[795]=",ExpressionUUID->"e6cfc70a-136f-4285-82ff-ce322ec4462d"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1XtczOkXB/BpmmqaZhq2hLBJ7pfW/liscA6SW0ltoqtuM2NRIUu2bMtK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      
      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(w\\), \\(ss\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.24115781102495687`},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.24115781102495687`}, {0.55, 0.2417115413704744}}], 
    LineBox[{{2.43, 0.24115781102495687`}, {2.43, 0.2417115413704744}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.24115781102495687`, 0.2417115413704744}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432293349409*^9},
 CellLabel->
  "Out[797]=",ExpressionUUID->"a3a1f001-b13c-4008-ba72-3250ce8c5d3d"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91XlczPv3B/CZZlqmPsvM1LSRwpWkbPna6xxbLkKhyyVcS7LLlSuyXbuo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      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(R\\), \\(ss\\)]\\)/100\"", TraditionalForm]},
  AxesOrigin->{0., 0.016648906186834535`},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.016648906186834535`}, {0.55, 0.0167727404574702}}], 
    LineBox[{{2.43, 0.016648906186834535`}, {2.43, 0.0167727404574702}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.016648906186834535`, 0.0167727404574702}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432293522719*^9},
 CellLabel->
  "Out[799]=",ExpressionUUID->"da34dba5-e8b0-46e6-9845-21dcb5e25eac"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF2HlcTPv/B/Cppm2apq71Zkl9kSwJ1Ywt77coce+15oaL6/Jz7Qkpy0VS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      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(y\\), \\(ss\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.3623788198046475},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.3623788198046475}, {0.55, 0.3627904872888918}}], 
    LineBox[{{2.43, 0.3623788198046475}, {2.43, 0.3627904872888918}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.3623788198046475, 0.3627904872888918}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432293703195*^9},
 CellLabel->
  "Out[801]=",ExpressionUUID->"e9f37c1b-43ad-443e-ab4d-67d5a787941f"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd2Hlczdn/B/Db7XarW90shSI0WowlWxhG3u9iFBMjIUt2UY0tosjSRIaU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      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Tau]\\), \\(ss\\)]\\)*1000\"", 
     TraditionalForm]},
  AxesOrigin->{0., 0.},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.}, {0.55, 0.1080706391855991}}], 
    LineBox[{{2.43, 0.}, {2.43, 0.1080706391855991}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0, 0.1080706391855991}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.8544322938837957`*^9},
 CellLabel->
  "Out[803]=",ExpressionUUID->"d478c021-19a7-4b02-aee3-3efadd43fd83"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF13lcjPsXB/CppmVa7ft6L7fldq3RNtM5M7ayKyFKivhZLkl2RZbse0WR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      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(s\\), \\(ss\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.09041760996246613},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.09041760996246613}, {0.55, 0.09086125360192858}}], 
    LineBox[{{2.43, 0.09041760996246613}, {2.43, 0.09086125360192858}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.09041760996246613, 0.09086125360192858}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.8544322940508966`*^9},
 CellLabel->
  "Out[805]=",ExpressionUUID->"d3c5d0fd-3dfd-4920-9500-b2718a877cee"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF2Hk81PkfB/Axxph7amOzukuLVHSvWt5v6bJyfIeIKUcHlXa7L9pOdP1E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      
      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*TemplateBox[{\\\"c\\\", \\\"1\\\", \
\\\"ss\\\"},\\\"Subsuperscript\\\"]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.15074020106249075`},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.15074020106249075`}, {0.55, 0.15095087626664297`}}], 
    LineBox[{{2.43, 0.15074020106249075`}, {2.43, 0.15095087626664297`}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.15074020106249075`, 0.15095087626664297`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432294232326*^9},
 CellLabel->
  "Out[807]=",ExpressionUUID->"850f3b56-d5ef-472f-8a41-fe48d7b6eb95"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91XlcjPsXB/BpmpppqhlCl4QSIoRkuxfn2LKErFGavSbElX3flyyXbLly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      "]]}}, {{}, {}}},
  AspectRatio->1.,
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"\[Tau]\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*TemplateBox[{\\\"c\\\", \\\"2\\\", \
\\\"ss\\\"},\\\"Subsuperscript\\\"]\\)\"", TraditionalForm]},
  AxesOrigin->{0., 0.1512735486222596},
  AxesStyle->Arrowheads[0.03],
  DisplayFunction->Identity,
  Epilog->{
    Directive[{
      Thickness[Large], 
      Dashing[{0, Small}], 
      GrayLevel[0.5]}], 
    LineBox[{{0.55, 0.1512735486222596}, {0.55, 0.1516551104685216}}], 
    LineBox[{{2.43, 0.1512735486222596}, {2.43, 0.1516551104685216}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{10, 20}, {10, 25}},
  LabelStyle->Directive[
    GrayLevel[0], 14],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 4.01}, {0.1512735486222596, 0.1516551104685216}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.2], 
     Scaled[0.2]}, {
     Scaled[0.2], 
     Scaled[0.2]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], 12]]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432294417706*^9},
 CellLabel->
  "Out[809]=",ExpressionUUID->"f14a3716-57b1-4541-82ce-17147ef6cd10"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, {{}, {}, 
      {GrayLevel[0], PointSize[
        NCache[
         Rational[1, 120], 0.008333333333333333]], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJxd1XlcjG0XB/Bpm/aFstRTQkR5EqJSOMdOoQVFUooWsrQp2kz7MqVtapI9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        "]]}, 
      {GrayLevel[0], PointSize[
        NCache[
         Rational[1, 120], 0.008333333333333333]], AbsoluteThickness[1.6], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxd1nk81Pv3B3CGwWBQcbuVqwhX6t6rffnGOW3ILdIqaVFZoiwlKZV9FzOW
sTNm6pYWKV1EmVLq3uKWKLQoEinJnt1PzfHP7/3PPGbeM+/3+7ye5/P5jOZe
1412DAkJCa6khMT31/8/vFWzTepPBMKUwnUNF+xtReL3cVAnoZf497CbqEAj
6LNlQTpwq9Za9L73ovmzcK5ohdXmhb6i5KTvIwsqHg4MqzwOoO9nw0CC3C+w
METUavn9k2sQObL5ScXRcPr9DQhzf18jiDojkq8WuhnK58PjCIFKIXJovZug
VT4hvO88VzTLJrqkR+8W7K3c1lM9HEPrF8PxM7WuU1bFic6O/bpaeAc4+Q3n
Pbziab+7UGIdvS8xnSea/2Pcg9sPZ43q5yXQ/vdh/Rbe+0eiRNG9Hr2xHUpB
d+WeHqVbSXSeh/DSr2Uo+FKyaOOPDf+BhMUL5W5FpdD5/gW3KtEDA/tUUf2J
7ws+ghvdZW9t56XRecvAelvIqgddaSL378dzKwctgw3HnlxMp/P/B1HLI9+0
bMsQiRWewkkZw/6TgxlUz1NYdvHFix4zvsj0xwYV8PO2xYaPYvlUXwVce9xd
61jDF33fzSb6GZyabP166OdMqrcScvO7uFe3ZIp+lFNdCVJZG05fiMqk+qtA
ZaK7O/t+pmj69+NoPIfAld9SGb2ZlMdz4Nj+ceGitkDkYP99vADHYyMluhsE
lE81iF6V5fO8BKLvq6lmV0NJ3LGhn9MFlFcNKLXvKHl0RyDq/b5cTw0Yrgpl
/vNOQPnVgqPN9JTZIwKR0Y8FX0JS86CR8hQh5fkSfL+k8iPmCkU/jhf0CroC
HF0LTISU72uYpLnO/vIOoai87Pt4DQeFpVtPHRJS3m9A8y+b+XhKKFL7ccA6
8GXFT2FFCCn/OlhuaLvjM08o+rGczVvgctRD+/lC8ngHUzsnHV2TJaR63oGT
lWDNu6tC8nkH3aYfD7+8IaT63oHvkpmVqwqE5FUPq7qz+LMLhVRvPdzOiPHl
j70X+9XDqatyYTk3hVR/A+xbvdnkQL6QPBugip9UWp07nkcDnF6ziSM3tr/Y
9z3sVwsvks0az+c9ZP/1tPldppC834Npj6RJRtJ4Xo3g2/Ivfz1HSP6NsNb2
29beoPH8GuHG9rQDwhNC6ocPcG6HlPcul/E8PwD4O1Ya2AqpP8bmg1L3z9w0
nm8TVIa6lButFlK/NIGkf49NxILxvJsg+n6u2gRtIfVPM6gHJ+RUTxzPvxk2
jdZkNEkIqZ+aIfDtzQlr2gTk8RFcN+p09b8c76+P0G68oFPhoYA8PsKK2fG+
ftfH++0jtL2ufb4nTUAeLdA360rH1ZDx/msBM8evaR7uAvIYm8+77XbDerwf
P0Gb+d7/PFYJRJwfHp9A1XDu58LZAvL4BJuLN5RHTBKQx2eAxa7mrQOZ5PEZ
otY4/FJfP379fYb9cc9ELv9kkkcrOD2KiE3KHr8eW2HrVq2ndnGZ5NEKzjmG
odXHx6/PL9B1uuti565M8vgCSw8pM4tWjV+vX8AkynzlAr1M8miDy01n2mwV
M8mjDUr/+OJp0s4njzYoWNKk/7GSTx5fQWPHdkOTfD55fIVdf0eXOiTzyeMr
qC+af2fdKT55tMMuLUOV/t18qqcdUve88nFdySefdnjy6/q717X5VF87vAzN
dy2V4ZNXO6z2bJi+uSKD6m0HJflorQdxGeTXDhPbj6Z+GLs/iuvvgK4B56n5
UzPIswO2t3oy4E065dEBxXEz4v0y0sm3A3B1YZu/bTrl0wGXfBLkTGamk3cH
PG5YWljRmEZ5dcLgvKOFun+lkX8n7J0bzF/rkEb5dcLyDZofDPXS6PrsBJ6v
53uZllTKsxPMlGa/PJ81/jzohJ3N61pnOqVSvl1wPGuZ1mn9VOqXLhDsDnS6
+SmF8u4Cu7X3k2suplD/dMHLR25udU4plH8XXP/7LLdcP4X6qQtc2t6fufAp
mTy6QW2kqs79YjJ5dIOkft/H2U7jz69u4JtuGaqZlUwe3bCBo7PFuyWJPLrB
d56nulpWEnl0g1FYqeMFxyTy6IaZKqlGi/WSyKMHrPQ1uPeaE8mjB7okU1Za
nE8kjx6YOVVN57V9Inn0gJrBgwFn3fHnbQ/4VrE8JZoSyKMHXtQvXp5yLoE8
emFkfmCDoV0CefSCdtCb9hbtBPLohYcqd+r5jTzy6AV9eYHW/rM88uiFnsU2
qgv388ijFwalohTUtHnk8Q0Cu0Y3MBvjyeMbqOdKasmejSePb3BwUmnOtP3x
5PENphXkaa/WjiePb3DEoDLZrzGOPL6BldqAzvOzceTRB/PuGD4Buzjy6IOl
cwx4JTpx5NEHIzJ/uO9qiiWPPjDZfWm96vlY8uiDWVdcVT44xJJHH6TNb4yv
0Isljz4Y7t5w/WVLDHn0g0ug+jzJSzHk0Q+eifIv1xyMIY9+sF10zCHrtxjy
6IfqsxzOnK9c8ugH7mC09NMcLnn0w6y2L85xh7nkMQC3bZIcTyzgkscAfPqs
x/Pv5ZDHAMxRUwy/UsCh++UATGwpqhw8wSGPAbhj1jJ0yJBDHgPw8MuFMGkJ
DnkMgmo9dPgERZPHIPjKWwevUIgmj0EwttYuMudGkccgyJ1c7HJhchR5DEKk
Q5SHRfoZ8hiEQfOnSat1zpDHEBgkJvJDL0eSxxDsXFa8Un1BJHkMgZZG/FyJ
WxHkMQRs1fk/LVwdQR5DUFB8hVtUFk4eQzCsamUYtyWcPIbAPGX0oqgujDyG
QS5a187IMYw8hiHMfvlXlc5Q8hiG1CWVpYtPhpLHMFziV+/KlQklj2H4e8nd
WYHc8f/Pw6Ae/TD6onoIeYyAi9GEbt0LweQxAnIdDbn984PJYwQYjHLdmXeC
yGMECvtr04XrgshjBO4y8h29awPJYwR2nq97fNE+kDxG4RmjRH5edwB5jAK7
++veCf4B5DEKtsnL2GtVAshjFAbL3hjWpvuTxyhoFWdql/zmTx6jMHv2aKvU
bT/ykMCwA1icvs6P6pFAmwBhUcxrX/KRwFzd49LvDvpSfWPffxzqyB70IS8J
/KCUW8r+xUf0o1x7CRzQ7DC9C6fJTwJlnV9P0tt3iu4PEti63WrFypCT5Dk2
v/PfD8qXvSkPCWxn/qnMrThBvhJomVtfWvrtOOUjgSU+lxSyNY6TtwSemqj8
Zq2xF+UlicKwLwZJLsfIXxI9jpX3pSR4Un6S+DKPqbnx7lHqB0lUt2jhFH32
oDwlsdK8Q7/mJw/qD0n0fN1Ydn7lEcpXEjVfDVvoux6mfpHE40WqYbtT3Slv
Sbyx+ZapySM36h9JvDf0Nq+kw5Xyl0RF6V2TdmxwoX6SxMGwFQbbcg6SBwPX
cZyi8yY4kwcDrUe4l7w8DpAHA11Xefal1jiQBwPdNH97r2VkTx4M7Dts9ox1
bj/1HwM7d/+qa8neRx4MvLZPdWmfpy15MHCy5nTR0L3d5MHAGfWfn5am2pAH
Axv1jy0z89pOHgzkPpkbGLp1K3kw8NjVE3N8Fm8iDwaOWgyenzNtA3lI4Y59
Xfc0pMzIQwp37Yw8/ufzVeQhheuky00Ktv+PPKTQxW0kfuGvv5OHFAoKOhRu
35UhDyn8/U+/ne05WiD2kMJTtUW3vU8vBLGHFD7b1z39SxmC2EMK7XUD/Nc/
NwaxhxR6VhUU7a1ZB2IPKZzIuGz8s7MliD2k8P4T4d6dDptB7CGNJ2tD0hm2
20DsIY269y61sqysQewxNr+pcPXRdTtB7CGNL+bfspw5fQ+IPaTxzEIT5h2e
LYg9pFHp7ow7E9j7QOwhjReML4RM8d8PYg9p7P7Jdl9Njx2IPaSxbUu5jYWj
A4g9xtZz3eXjU+sIYg9p/PX1tpoDa51A7CGNJnEiT+UCZxB7SOMRi2XO7jqH
QOzBxBg/yX84XBcQezAx7fxjvsuQK4g9mDiNYcWUyXUDsQcT529XVFro4A5i
DyZGrNrWe3/qYRB7MNFwdqZZXvlh8mAi07QhgeV7hDyYGKnCdRbN9SAPJtY/
y9hU0+BBHkx8rHa0bnPsUfJgord6XfLCVZ7kwUTjm6yfvTs9yUMGlw/5fdDJ
PEYeMujkrRm7yMKLPGRw23Tla1eGvMhDBm9NuPEkIus4ecig0c08n4otJ8hD
Bhmfuix9JL3JQwYvH/Cqjr/sTR4yqD/bK1Nt20nykEGND3+uGJU4RR4y6OF+
wHTTxVPkIYMV5TtNJ246TR4yODnp4bPlg6fJQwbVGi2PVwp8yEMWM3Ne2H/W
9iUPWbxd8DBnppcvecjif0Gb30987EsestjmZ2ly8xc/8pDFp7PO6Ex28yMP
WTzrUf5gTokfechiYHT5kYFJ/uQhiwW3lh/1tfMnD1lMOnJzkijPnzxkUX20
MiFPNoA8ZNHTSdbMwSqAPGRxRlnR4YoLAeQhh4UdK617+gLIQw5zhFWmlaaB
5CGHQ37cYOfEQPKQQ4vLJ3cUNweShxyqik4qly0KIg85DA+1/hQXFEQecmhs
XDx/SlUQiJ+fctgo8/v87VrB5CGHOi/YBlvcgslDDiEvzZ1dHEwecnjZ4JuR
v0IIecjhVQelt7lWIeQhh7KJ2YmCcyHkwcK2h8evm3eGkAcLf6/7eLjAKJQ8
WLjhqcmMd+Gh5MFCPSyQePAilDxYeMRkjrWTVhh5sPDcwIHD5YfCyIOFmmXM
6K8FYeTBwod/2fU8lQonDxY6nC7+5G4eTh4sPGA68cazxHDyYOFrxbm8roZw
8mDh1tr851VzIshDHuuilfI9PSPIQx4dzzqerhVFkIc8blx633VYLpI85JFr
1/Jfg2UkecjjZWfHt2HJkeQhjxqslMbOhkjykEeVaoGmxuwz5CGPbD3HWoUj
Z8hDHrN+SzG/VXiGPOTx/aHr9/5gRJGHPFrsbTlhvzaKPOSxmrkybw8nijzk
UbLcP1+jOoo8FLDGcdEd/i/R5KGAlpJXJjTviyYPBXzS1t/akRVNHgrYy+2K
ufs1mjwUULllitalqRzyUMAtMREzrAw55KGAtlfrGpt3c8hDAT/KS0db+3PI
QwH5uuVGOWc55KGA17JbJ7U84JCHAhb9r/c3ZguHPMb29995WVqBSx6K2Kt+
LLt5Dpc8FNFOz2tTtjmXPBTxJ0XPQis3Lnko4rR2O0Yzl0seinjaTMNsey6X
PBTRU7A552oVlzwUcZFlxqZPPVzyUMSytR4bWZNjyEMRC9bPeqy4JIY8FPFZ
everbqsY8lDEkYHPgrvHY8hDEd21mUZHkmPIQxGXBao9ZhXFkAcb284/cwh6
FUMebPQNrpjbNBhDHmzsmhtiPEc9ljzYyHM1vbdteSx5sFHTbm2po00sebDx
TlP6gd0nY8mDjZMDlpf/LzWWPNiourpXcaQoljzYaNjis+avV7HkwUadjwdj
FwzGkgcbc/0MJmVNjSMPNh6aoVEvtSyOPJRwZYXjlDXb48hDCU8lzKw56BVH
HkqYcWnFUu+EOPJQwqFfeFZueXHkoYTTZ1RZrnseRx5KWHwtCpW748hDCUfv
L8WbE+PJQwmb0vQOms2NJw8lXD0j+m2JRTx5KGGakv/fWi7x5KGEsQd65Jwi
48lDCSOvFHcnXownDyUs2xEbe/WfePJQxiUJLInspnjyUMbF5omb46R55KGM
NroJl/Zq8chDGR84GE2fgjzyUEbDHef/zd/JIw9lVN9Sdt/Im0ceymi8JFQ/
O5FHHsr48WaCqkwejzyUMSE4MdW4kkceyjhtL+u1azuPPJTxyg6zVj92AnmM
nW9OWtNJ/QTyUMFwH53GPSYJ8H8muPys
        "]]}}, {{}, {}}}, InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*FractionBox[\\(\\*SubscriptBox[\\(x\\), \
\\(1\\)]*\\*SubscriptBox[\\(c\\), \\(1, \[Tau]\\)]\\), SubscriptBox[\\(y\\), \
\\(\[Tau]\\)]]\\)*100\"", 
       "\"\\!\\(\\*FractionBox[\\(\\*SubscriptBox[\\(x\\), \
\\(2\\)]*\\*SubscriptBox[\\(c\\), \\(2, \[Tau]\\)]\\), SubscriptBox[\\(y\\), \
\\(\[Tau]\\)]]\\)*100\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], 12], FontFamily -> "Arial"}, Background -> Automatic,
          StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                 "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                   ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 "12"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Row\"", ",", "2"}], "}"}]}]}], "]"}]& )], 
     Scaled[{0.75, 0.3}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->1.,
   Axes->{True, True},
   AxesLabel->{
     FormBox["\"\[Tau]\"", TraditionalForm], 
     FormBox["\"%\"", TraditionalForm]},
   AxesOrigin->{0., 0.},
   AxesStyle->Arrowheads[0.03],
   DisplayFunction->Identity,
   Epilog->{
     Directive[{
       Thickness[Large], 
       Dashing[{0, Small}], 
       GrayLevel[0.5]}], 
     LineBox[{{0.55, -0.1}, {0.55, 0.1}}], 
     LineBox[{{2.43, -0.1}, {2.43, 0.1}}]},
   Frame->{{False, False}, {False, False}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->{{10, 20}, {10, 25}},
   LabelStyle->Directive[
     GrayLevel[0], 12],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{-0.01, 4.01}, {-0.03853322572223259, 0.022733224797206776`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.2], 
      Scaled[0.2]}, {
      Scaled[0.2], 
      Scaled[0.2]}},
   Ticks->{{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}, {3, 
       FormBox["3", TraditionalForm]}, {4, 
       FormBox["4", TraditionalForm]}}, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxd1XlcjG0XB/Bpm/aFstRTQkR5EqJSOMdOoQVFUooWsrQp2kz7MqVtapI9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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 120]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{Small, Small}]], 
         Line[CompressedData["
1:eJxd1nk81Pv3B3CGwWBQcbuVqwhX6t6rffnGOW3ILdIqaVFZoiwlKZV9FzOW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          "]]}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      1., Axes -> {True, True}, AxesLabel -> {"\[Tau]", "%"}, 
      AxesOrigin -> {0., 0.}, AxesStyle -> Arrowheads[0.03], DisplayFunction :> 
      Identity, Epilog -> {
        Directive[{
          Thickness[Large], 
          Dashing[{0, Small}], 
          GrayLevel[0.5]}], 
        Line[{{0.55, -0.1}, {0.55, 0.1}}], 
        Line[{{2.43, -0.1}, {2.43, 0.1}}]}, 
      Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImagePadding -> {{10, 20}, {10, 25}}, 
      LabelStyle -> Directive[
        GrayLevel[0], 12], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-0.01, 4.01}, {-0.03853322572223259, 
       0.022733224797206776`}}, PlotRangeClipping -> True, 
      PlotRangePadding -> {{
         Scaled[0.2], 
         Scaled[0.2]}, {
         Scaled[0.2], 
         Scaled[0.2]}}, Ticks -> {{0, 1, 2, 3, 4}, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         GrayLevel[0]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Dashing[{Small, Small}]]}, {
       "\!\(\*FractionBox[\(\*SubscriptBox[\(x\), \
\(1\)]*\*SubscriptBox[\(c\), \(1, \[Tau]\)]\), SubscriptBox[\(y\), \
\(\[Tau]\)]]\)*100", 
        "\!\(\*FractionBox[\(\*SubscriptBox[\(x\), \
\(2\)]*\*SubscriptBox[\(c\), \(2, \[Tau]\)]\), SubscriptBox[\(y\), \
\(\[Tau]\)]]\)*100"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}}, 
       Joined -> {True, True}, LabelStyle -> Directive[
         GrayLevel[0], 12], LegendLayout -> {"Row", 2}]], {0.75, 0.3}, 
     Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432294615054*^9},
 CellLabel->
  "Out[811]=",ExpressionUUID->"095e3a1c-d5ec-4a5a-95f3-8cf016c0011f"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {{}, {}, 
       {GrayLevel[0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], AbsoluteThickness[1.6], 
        LineBox[CompressedData["
1:eJxd1XlcjG0XB/Bpm/aFstRTQkR5EqJSOMdOoQVFUooWsrQp2kz7MqVtapI9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         "]]}, 
       {GrayLevel[0], PointSize[
         NCache[
          Rational[1, 120], 0.008333333333333333]], AbsoluteThickness[1.6], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxd1nk81Pv3B3CGwWBQcbuVqwhX6t6rffnGOW3ILdIqaVFZoiwlKZV9FzOW
sTNm6pYWKV1EmVLq3uKWKLQoEinJnt1PzfHP7/3PPGbeM+/3+7ye5/P5jOZe
1412DAkJCa6khMT31/8/vFWzTepPBMKUwnUNF+xtReL3cVAnoZf497CbqEAj
6LNlQTpwq9Za9L73ovmzcK5ohdXmhb6i5KTvIwsqHg4MqzwOoO9nw0CC3C+w
METUavn9k2sQObL5ScXRcPr9DQhzf18jiDojkq8WuhnK58PjCIFKIXJovZug
VT4hvO88VzTLJrqkR+8W7K3c1lM9HEPrF8PxM7WuU1bFic6O/bpaeAc4+Q3n
Pbziab+7UGIdvS8xnSea/2Pcg9sPZ43q5yXQ/vdh/Rbe+0eiRNG9Hr2xHUpB
d+WeHqVbSXSeh/DSr2Uo+FKyaOOPDf+BhMUL5W5FpdD5/gW3KtEDA/tUUf2J
7ws+ghvdZW9t56XRecvAelvIqgddaSL378dzKwctgw3HnlxMp/P/B1HLI9+0
bMsQiRWewkkZw/6TgxlUz1NYdvHFix4zvsj0xwYV8PO2xYaPYvlUXwVce9xd
61jDF33fzSb6GZyabP166OdMqrcScvO7uFe3ZIp+lFNdCVJZG05fiMqk+qtA
ZaK7O/t+pmj69+NoPIfAld9SGb2ZlMdz4Nj+ceGitkDkYP99vADHYyMluhsE
lE81iF6V5fO8BKLvq6lmV0NJ3LGhn9MFlFcNKLXvKHl0RyDq/b5cTw0Yrgpl
/vNOQPnVgqPN9JTZIwKR0Y8FX0JS86CR8hQh5fkSfL+k8iPmCkU/jhf0CroC
HF0LTISU72uYpLnO/vIOoai87Pt4DQeFpVtPHRJS3m9A8y+b+XhKKFL7ccA6
8GXFT2FFCCn/OlhuaLvjM08o+rGczVvgctRD+/lC8ngHUzsnHV2TJaR63oGT
lWDNu6tC8nkH3aYfD7+8IaT63oHvkpmVqwqE5FUPq7qz+LMLhVRvPdzOiPHl
j70X+9XDqatyYTk3hVR/A+xbvdnkQL6QPBugip9UWp07nkcDnF6ziSM3tr/Y
9z3sVwsvks0az+c9ZP/1tPldppC834Npj6RJRtJ4Xo3g2/Ivfz1HSP6NsNb2
29beoPH8GuHG9rQDwhNC6ocPcG6HlPcul/E8PwD4O1Ya2AqpP8bmg1L3z9w0
nm8TVIa6lButFlK/NIGkf49NxILxvJsg+n6u2gRtIfVPM6gHJ+RUTxzPvxk2
jdZkNEkIqZ+aIfDtzQlr2gTk8RFcN+p09b8c76+P0G68oFPhoYA8PsKK2fG+
ftfH++0jtL2ufb4nTUAeLdA360rH1ZDx/msBM8evaR7uAvIYm8+77XbDerwf
P0Gb+d7/PFYJRJwfHp9A1XDu58LZAvL4BJuLN5RHTBKQx2eAxa7mrQOZ5PEZ
otY4/FJfP379fYb9cc9ELv9kkkcrOD2KiE3KHr8eW2HrVq2ndnGZ5NEKzjmG
odXHx6/PL9B1uuti565M8vgCSw8pM4tWjV+vX8AkynzlAr1M8miDy01n2mwV
M8mjDUr/+OJp0s4njzYoWNKk/7GSTx5fQWPHdkOTfD55fIVdf0eXOiTzyeMr
qC+af2fdKT55tMMuLUOV/t18qqcdUve88nFdySefdnjy6/q717X5VF87vAzN
dy2V4ZNXO6z2bJi+uSKD6m0HJflorQdxGeTXDhPbj6Z+GLs/iuvvgK4B56n5
UzPIswO2t3oy4E065dEBxXEz4v0y0sm3A3B1YZu/bTrl0wGXfBLkTGamk3cH
PG5YWljRmEZ5dcLgvKOFun+lkX8n7J0bzF/rkEb5dcLyDZofDPXS6PrsBJ6v
53uZllTKsxPMlGa/PJ81/jzohJ3N61pnOqVSvl1wPGuZ1mn9VOqXLhDsDnS6
+SmF8u4Cu7X3k2suplD/dMHLR25udU4plH8XXP/7LLdcP4X6qQtc2t6fufAp
mTy6QW2kqs79YjJ5dIOkft/H2U7jz69u4JtuGaqZlUwe3bCBo7PFuyWJPLrB
d56nulpWEnl0g1FYqeMFxyTy6IaZKqlGi/WSyKMHrPQ1uPeaE8mjB7okU1Za
nE8kjx6YOVVN57V9Inn0gJrBgwFn3fHnbQ/4VrE8JZoSyKMHXtQvXp5yLoE8
emFkfmCDoV0CefSCdtCb9hbtBPLohYcqd+r5jTzy6AV9eYHW/rM88uiFnsU2
qgv388ijFwalohTUtHnk8Q0Cu0Y3MBvjyeMbqOdKasmejSePb3BwUmnOtP3x
5PENphXkaa/WjiePb3DEoDLZrzGOPL6BldqAzvOzceTRB/PuGD4Buzjy6IOl
cwx4JTpx5NEHIzJ/uO9qiiWPPjDZfWm96vlY8uiDWVdcVT44xJJHH6TNb4yv
0Isljz4Y7t5w/WVLDHn0g0ug+jzJSzHk0Q+eifIv1xyMIY9+sF10zCHrtxjy
6IfqsxzOnK9c8ugH7mC09NMcLnn0w6y2L85xh7nkMQC3bZIcTyzgkscAfPqs
x/Pv5ZDHAMxRUwy/UsCh++UATGwpqhw8wSGPAbhj1jJ0yJBDHgPw8MuFMGkJ
DnkMgmo9dPgERZPHIPjKWwevUIgmj0EwttYuMudGkccgyJ1c7HJhchR5DEKk
Q5SHRfoZ8hiEQfOnSat1zpDHEBgkJvJDL0eSxxDsXFa8Un1BJHkMgZZG/FyJ
WxHkMQRs1fk/LVwdQR5DUFB8hVtUFk4eQzCsamUYtyWcPIbAPGX0oqgujDyG
QS5a187IMYw8hiHMfvlXlc5Q8hiG1CWVpYtPhpLHMFziV+/KlQklj2H4e8nd
WYHc8f/Pw6Ae/TD6onoIeYyAi9GEbt0LweQxAnIdDbn984PJYwQYjHLdmXeC
yGMECvtr04XrgshjBO4y8h29awPJYwR2nq97fNE+kDxG4RmjRH5edwB5jAK7
++veCf4B5DEKtsnL2GtVAshjFAbL3hjWpvuTxyhoFWdql/zmTx6jMHv2aKvU
bT/ykMCwA1icvs6P6pFAmwBhUcxrX/KRwFzd49LvDvpSfWPffxzqyB70IS8J
/KCUW8r+xUf0o1x7CRzQ7DC9C6fJTwJlnV9P0tt3iu4PEti63WrFypCT5Dk2
v/PfD8qXvSkPCWxn/qnMrThBvhJomVtfWvrtOOUjgSU+lxSyNY6TtwSemqj8
Zq2xF+UlicKwLwZJLsfIXxI9jpX3pSR4Un6S+DKPqbnx7lHqB0lUt2jhFH32
oDwlsdK8Q7/mJw/qD0n0fN1Ydn7lEcpXEjVfDVvoux6mfpHE40WqYbtT3Slv
Sbyx+ZapySM36h9JvDf0Nq+kw5Xyl0RF6V2TdmxwoX6SxMGwFQbbcg6SBwPX
cZyi8yY4kwcDrUe4l7w8DpAHA11Xefal1jiQBwPdNH97r2VkTx4M7Dts9ox1
bj/1HwM7d/+qa8neRx4MvLZPdWmfpy15MHCy5nTR0L3d5MHAGfWfn5am2pAH
Axv1jy0z89pOHgzkPpkbGLp1K3kw8NjVE3N8Fm8iDwaOWgyenzNtA3lI4Y59
Xfc0pMzIQwp37Yw8/ufzVeQhheuky00Ktv+PPKTQxW0kfuGvv5OHFAoKOhRu
35UhDyn8/U+/ne05WiD2kMJTtUW3vU8vBLGHFD7b1z39SxmC2EMK7XUD/Nc/
NwaxhxR6VhUU7a1ZB2IPKZzIuGz8s7MliD2k8P4T4d6dDptB7CGNJ2tD0hm2
20DsIY269y61sqysQewxNr+pcPXRdTtB7CGNL+bfspw5fQ+IPaTxzEIT5h2e
LYg9pFHp7ow7E9j7QOwhjReML4RM8d8PYg9p7P7Jdl9Njx2IPaSxbUu5jYWj
A4g9xtZz3eXjU+sIYg9p/PX1tpoDa51A7CGNJnEiT+UCZxB7SOMRi2XO7jqH
QOzBxBg/yX84XBcQezAx7fxjvsuQK4g9mDiNYcWUyXUDsQcT529XVFro4A5i
DyZGrNrWe3/qYRB7MNFwdqZZXvlh8mAi07QhgeV7hDyYGKnCdRbN9SAPJtY/
y9hU0+BBHkx8rHa0bnPsUfJgord6XfLCVZ7kwUTjm6yfvTs9yUMGlw/5fdDJ
PEYeMujkrRm7yMKLPGRw23Tla1eGvMhDBm9NuPEkIus4ecig0c08n4otJ8hD
Bhmfuix9JL3JQwYvH/Cqjr/sTR4yqD/bK1Nt20nykEGND3+uGJU4RR4y6OF+
wHTTxVPkIYMV5TtNJ246TR4yODnp4bPlg6fJQwbVGi2PVwp8yEMWM3Ne2H/W
9iUPWbxd8DBnppcvecjif0Gb30987EsestjmZ2ly8xc/8pDFp7PO6Ex28yMP
WTzrUf5gTokfechiYHT5kYFJ/uQhiwW3lh/1tfMnD1lMOnJzkijPnzxkUX20
MiFPNoA8ZNHTSdbMwSqAPGRxRlnR4YoLAeQhh4UdK617+gLIQw5zhFWmlaaB
5CGHQ37cYOfEQPKQQ4vLJ3cUNweShxyqik4qly0KIg85DA+1/hQXFEQecmhs
XDx/SlUQiJ+fctgo8/v87VrB5CGHOi/YBlvcgslDDiEvzZ1dHEwecnjZ4JuR
v0IIecjhVQelt7lWIeQhh7KJ2YmCcyHkwcK2h8evm3eGkAcLf6/7eLjAKJQ8
WLjhqcmMd+Gh5MFCPSyQePAilDxYeMRkjrWTVhh5sPDcwIHD5YfCyIOFmmXM
6K8FYeTBwod/2fU8lQonDxY6nC7+5G4eTh4sPGA68cazxHDyYOFrxbm8roZw
8mDh1tr851VzIshDHuuilfI9PSPIQx4dzzqerhVFkIc8blx633VYLpI85JFr
1/Jfg2UkecjjZWfHt2HJkeQhjxqslMbOhkjykEeVaoGmxuwz5CGPbD3HWoUj
Z8hDHrN+SzG/VXiGPOTx/aHr9/5gRJGHPFrsbTlhvzaKPOSxmrkybw8nijzk
UbLcP1+jOoo8FLDGcdEd/i/R5KGAlpJXJjTviyYPBXzS1t/akRVNHgrYy+2K
ufs1mjwUULllitalqRzyUMAtMREzrAw55KGAtlfrGpt3c8hDAT/KS0db+3PI
QwH5uuVGOWc55KGA17JbJ7U84JCHAhb9r/c3ZguHPMb29995WVqBSx6K2Kt+
LLt5Dpc8FNFOz2tTtjmXPBTxJ0XPQis3Lnko4rR2O0Yzl0seinjaTMNsey6X
PBTRU7A552oVlzwUcZFlxqZPPVzyUMSytR4bWZNjyEMRC9bPeqy4JIY8FPFZ
everbqsY8lDEkYHPgrvHY8hDEd21mUZHkmPIQxGXBao9ZhXFkAcb284/cwh6
FUMebPQNrpjbNBhDHmzsmhtiPEc9ljzYyHM1vbdteSx5sFHTbm2po00sebDx
TlP6gd0nY8mDjZMDlpf/LzWWPNiourpXcaQoljzYaNjis+avV7HkwUadjwdj
FwzGkgcbc/0MJmVNjSMPNh6aoVEvtSyOPJRwZYXjlDXb48hDCU8lzKw56BVH
HkqYcWnFUu+EOPJQwqFfeFZueXHkoYTTZ1RZrnseRx5KWHwtCpW748hDCUfv
L8WbE+PJQwmb0vQOms2NJw8lXD0j+m2JRTx5KGGakv/fWi7x5KGEsQd65Jwi
48lDCSOvFHcnXownDyUs2xEbe/WfePJQxiUJLInspnjyUMbF5omb46R55KGM
NroJl/Zq8chDGR84GE2fgjzyUEbDHef/zd/JIw9lVN9Sdt/Im0ceymi8JFQ/
O5FHHsr48WaCqkwejzyUMSE4MdW4kkceyjhtL+u1azuPPJTxyg6zVj92AnmM
nW9OWtNJ/QTyUMFwH53GPSYJ8H8muPys
         "]]}}, {{}, {}}}, InsetBox[
      StyleBox["\<\"0\"\>",
       StripOnInput->False,
       LineColor->GrayLevel[0],
       FrontFaceColor->GrayLevel[0],
       BackFaceColor->GrayLevel[0],
       GraphicsColor->GrayLevel[0],
       FontSize->12,
       FontColor->GrayLevel[0]], {-0.1, 0.002}]}, InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*FractionBox[\\(\\*SubscriptBox[\\(x\\), \
\\(1\\)]*\\*SubscriptBox[\\(c\\), \\(1, \[Tau]\\)]\\), SubscriptBox[\\(y\\), \
\\(\[Tau]\\)]]\\)*100\"", 
       "\"\\!\\(\\*FractionBox[\\(\\*SubscriptBox[\\(x\\), \
\\(2\\)]*\\*SubscriptBox[\\(c\\), \\(2, \[Tau]\\)]\\), SubscriptBox[\\(y\\), \
\\(\[Tau]\\)]]\\)*100\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], 12], FontFamily -> "Arial"}, Background -> Automatic,
          StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                 "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "120"], "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                   ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 "12"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Row\"", ",", "2"}], "}"}]}]}], "]"}]& )], 
     Scaled[{0.75, 0.3}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->1.,
   Axes->{True, True},
   AxesLabel->{
     FormBox["\"\[Tau]\"", TraditionalForm], 
     FormBox["\"%\"", TraditionalForm]},
   AxesOrigin->{0., 0.},
   AxesStyle->Arrowheads[0.03],
   DisplayFunction->Identity,
   Epilog->{
     Directive[{
       Thickness[Large], 
       Dashing[{0, Small}], 
       GrayLevel[0.5]}], 
     LineBox[{{0.55, -0.1}, {0.55, 0.1}}], 
     LineBox[{{2.43, -0.1}, {2.43, 0.1}}]},
   Frame->{{False, False}, {False, False}},
   FrameLabel->{{None, None}, {None, None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->{{10, 20}, {10, 25}},
   LabelStyle->Directive[
     GrayLevel[0], 12],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{-0.01, 4.01}, {-0.03853322572223259, 0.022733224797206776`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.2], 
      Scaled[0.2]}, {
      Scaled[0.2], 
      Scaled[0.2]}},
   Ticks->{{{0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}, {3, 
       FormBox["3", TraditionalForm]}, {4, 
       FormBox["4", TraditionalForm]}}, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[
            Rational[1, 120]], 
           AbsoluteThickness[1.6], 
           GrayLevel[0]], 
          Line[CompressedData["
1:eJxd1XlcjG0XB/Bpm/aFstRTQkR5EqJSOMdOoQVFUooWsrQp2kz7MqVtapI9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           "]]}, {
          Hue[0.9060679774997897, 0.6, 0.6], 
          Directive[
           PointSize[
            Rational[1, 120]], 
           AbsoluteThickness[1.6], 
           GrayLevel[0], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJxd1nk81Pv3B3CGwWBQcbuVqwhX6t6rffnGOW3ILdIqaVFZoiwlKZV9FzOW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           "]]}}}, {{}, {}}}, 
      Text[
       Style["0", 
        GrayLevel[0], 12], {-0.1, 0.002}]}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      1., Axes -> {True, True}, AxesLabel -> {"\[Tau]", "%"}, 
      AxesOrigin -> {0., 0.}, AxesStyle -> Arrowheads[0.03], DisplayFunction :> 
      Identity, Epilog -> {
        Directive[{
          Thickness[Large], 
          Dashing[{0, Small}], 
          GrayLevel[0.5]}], 
        Line[{{0.55, -0.1}, {0.55, 0.1}}], 
        Line[{{2.43, -0.1}, {2.43, 0.1}}]}, 
      Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImagePadding -> {{10, 20}, {10, 25}}, 
      LabelStyle -> Directive[
        GrayLevel[0], 12], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-0.01, 4.01}, {-0.03853322572223259, 
       0.022733224797206776`}}, PlotRangeClipping -> True, 
      PlotRangePadding -> {{
         Scaled[0.2], 
         Scaled[0.2]}, {
         Scaled[0.2], 
         Scaled[0.2]}}, Ticks -> {{0, 1, 2, 3, 4}, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         GrayLevel[0]], 
        Directive[
         PointSize[
          Rational[1, 120]], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Dashing[{Small, Small}]]}, {
       "\!\(\*FractionBox[\(\*SubscriptBox[\(x\), \
\(1\)]*\*SubscriptBox[\(c\), \(1, \[Tau]\)]\), SubscriptBox[\(y\), \
\(\[Tau]\)]]\)*100", 
        "\!\(\*FractionBox[\(\*SubscriptBox[\(x\), \
\(2\)]*\*SubscriptBox[\(c\), \(2, \[Tau]\)]\), SubscriptBox[\(y\), \
\(\[Tau]\)]]\)*100"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}}, 
       Joined -> {True, True}, LabelStyle -> Directive[
         GrayLevel[0], 12], LegendLayout -> {"Row", 2}]], {0.75, 0.3}, 
     Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432294645384*^9},
 CellLabel->
  "Out[812]=",ExpressionUUID->"5794bc25-4029-45d8-8291-04ca64915ed2"],

Cell[BoxData["\<\"./figures/generalized_linearized_tax_CE.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.8544322948584967`*^9},
 CellLabel->
  "Out[813]=",ExpressionUUID->"0147e482-8b2a-4afd-a955-364de7334249"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJw113lczfn3B/C737pLhUrKUomKIrKm7jmWSGYsUbYaosXI4Dd2yZIMIzvZ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           
           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(p\\), \\(ss\\)]\\)\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0}, {0.55, 0.0002552169968249995}}], 
         LineBox[{{2.43, 0}, {2.43, 0.0002552169968249995}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0, 0.0002552169968249995}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {193.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJw91XlcDPgbB/CpaWpmamZoI2e7KFfOsqyr51lnYiXrWIldOXatXZslVi1Z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           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(k\\), \\(ss\\)]\\)\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.0720174143522766},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.0720174143522766}, {0.55, 0.07261659594211733}}], 
         LineBox[{{2.43, 0.0720174143522766}, {2.43, 0.07261659594211733}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.0720174143522766, 0.07261659594211733}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {580.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxF2HlcTPv/B/Cppm2apq71Zkl9kSwJ1Ywt77coce+15oaL6/Jz7Qkpy0VS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           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(y\\), \\(ss\\)]\\)\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.3623788198046475},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.3623788198046475}, {0.55, 0.3627904872888918}}], 
         LineBox[{{2.43, 0.3623788198046475}, {2.43, 0.3627904872888918}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.3623788198046475, 0.3627904872888918}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxF1XtczOkXB/BpmmqaZhq2hLBJ7pfW/liscA6SW0ltoqtuM2NRIUu2bMtK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           
           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(w\\), \\(ss\\)]\\)\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.24115781102495687`},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.24115781102495687`}, {0.55, 0.2417115413704744}}], 
         
         LineBox[{{2.43, 0.24115781102495687`}, {2.43, 0.2417115413704744}}]},
       
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.24115781102495687`, 0.2417115413704744}},
       
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {193.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJw91XlczPv3B/CZZlqmPsvM1LSRwpWkbPna6xxbLkKhyyVcS7LLlSuyXbuo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           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(R\\), \\(ss\\)]\\)/100\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.016648906186834535`},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.016648906186834535`}, {0.55, 0.0167727404574702}}], 
         LineBox[{{2.43, 0.016648906186834535`}, {2.43, 0.0167727404574702}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.016648906186834535`, 0.0167727404574702}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {580.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxd2Hlczdn/B/Db7XarW90shSI0WowlWxhG3u9iFBMjIUt2UY0tosjSRIaU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           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(\[Tau]\\), \\(ss\\)]\\)*1000\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.}, {0.55, 0.1080706391855991}}], 
         LineBox[{{2.43, 0.}, {2.43, 0.1080706391855991}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0, 0.1080706391855991}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxF13lcjPsXB/CppmVa7ft6L7fldq3RNtM5M7ayKyFKivhZLkl2RZbse0WR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           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SuperscriptBox[\\(s\\), \\(ss\\)]\\)\"", 
          TraditionalForm]},
       AxesOrigin->{0., 0.09041760996246613},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.09041760996246613}, {0.55, 0.09086125360192858}}], 
         
         LineBox[{{2.43, 0.09041760996246613}, {2.43, 0.09086125360192858}}]},
       
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.09041760996246613, 0.09086125360192858}},
       
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxF2Hk81PkfB/Axxph7amOzukuLVHSvWt5v6bJyfIeIKUcHlXa7L9pOdP1E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           
           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*TemplateBox[{\\\"c\\\", \\\"1\\\", \
\\\"ss\\\"},\\\"Subsuperscript\\\"]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.15074020106249075`},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.15074020106249075`}, {0.55, 
          0.15095087626664297`}}], 
         LineBox[{{2.43, 0.15074020106249075`}, {2.43, 
          0.15095087626664297`}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.15074020106249075`, 
        0.15095087626664297`}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {{}, {}, 
         {GrayLevel[0], PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJw91XlcjPsXB/BpmpppqhlCl4QSIoRkuxfn2LKErFGavSbElX3flyyXbLly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           "]]}}, {{}, {}}},
       AspectRatio->1.,
       Axes->{True, True},
       AxesLabel->{
         FormBox["\"\[Tau]\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*TemplateBox[{\\\"c\\\", \\\"2\\\", \
\\\"ss\\\"},\\\"Subsuperscript\\\"]\\)\"", TraditionalForm]},
       AxesOrigin->{0., 0.1512735486222596},
       AxesStyle->Arrowheads[0.03],
       DisplayFunction->Identity,
       Epilog->{
         Directive[{
           Thickness[Large], 
           Dashing[{0, Small}], 
           GrayLevel[0.5]}], 
         LineBox[{{0.55, 0.1512735486222596}, {0.55, 0.1516551104685216}}], 
         LineBox[{{2.43, 0.1512735486222596}, {2.43, 0.1516551104685216}}]},
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{10, 20}, {10, 25}},
       LabelStyle->Directive[
         GrayLevel[0], 14],
       Method->{
        "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& )}},
       PlotRange->{{-0.01, 4.01}, {0.1512735486222596, 0.1516551104685216}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.2], 
          Scaled[0.2]}, {
          Scaled[0.2], 
          Scaled[0.2]}},
       Ticks->{{{0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, Automatic},
       TicksStyle->Directive[
         GrayLevel[0], 12]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, {}},
  ImageSize->Automatic,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.7808064727978783`*^9, {3.7808065313143682`*^9, 3.780806549898596*^9}, {
   3.780807119246217*^9, 3.780807140496697*^9}, 3.7808071805685177`*^9, 
   3.780807211365501*^9, 3.780850709711643*^9, 3.78085080176271*^9, {
   3.780850867125298*^9, 3.780850914013232*^9}, 3.780850997611817*^9, 
   3.78085104823071*^9, 3.780851220059725*^9, 3.780851371266159*^9, 
   3.780851499149971*^9, 3.780851588449767*^9, 3.780851734918406*^9, 
   3.780851855669013*^9, 3.780851897230002*^9, {3.780852027834155*^9, 
   3.780852054061364*^9}, 3.780852109402872*^9, 3.780852319369483*^9, 
   3.780852367255765*^9, 3.780852427239539*^9, 3.7808524956032877`*^9, 
   3.780852637186426*^9, {3.780852779480796*^9, 3.780852826069097*^9}, 
   3.780853035188107*^9, {3.780853187438879*^9, 3.78085322837286*^9}, {
   3.78085326052241*^9, 3.7808533001561213`*^9}, 3.7814310485923*^9, 
   3.781431108840376*^9, 3.781431162133587*^9, {3.7814311931390133`*^9, 
   3.7814312159291363`*^9}, 3.7814312496955633`*^9, 3.7814314194167643`*^9, {
   3.781431470420835*^9, 3.781431486212831*^9}, 3.781431587259199*^9, 
   3.78143169281557*^9, 3.7814317235559072`*^9, {3.781694870805498*^9, 
   3.781694890363991*^9}, 3.781694974168646*^9, 3.781695025869499*^9, 
   3.781695157798089*^9, 3.7816953177354717`*^9, 3.781695383381866*^9, 
   3.7816954167304792`*^9, {3.781695733028945*^9, 3.781695773431294*^9}, 
   3.7816959186946087`*^9, 3.78169826371154*^9, 3.7816993340345373`*^9, 
   3.781699417765127*^9, 3.781859757676165*^9, 3.781859806374813*^9, {
   3.781859841076038*^9, 3.78185989440889*^9}, 3.781860090184785*^9, 
   3.781860158937111*^9, 3.781860192747065*^9, 3.7818602490225267`*^9, 
   3.781860296663871*^9, 3.78186039322556*^9, 3.854431900532054*^9, 
   3.8544320538425627`*^9, 3.854432294884225*^9},
 CellLabel->
  "Out[814]=",ExpressionUUID->"5c07177e-951b-44bc-8af6-671cd149510f"]
}, Open  ]],

Cell[BoxData["  "], "Input",
 CellChangeTimes->{{3.778390089129891*^9, 
  3.778390090872725*^9}},ExpressionUUID->"133c3aaf-70d2-4e36-b171-\
7fc824339cd2"]
},
WindowSize->{1084, 517},
WindowMargins->{{73, Automatic}, {Automatic, 34}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5551cb58-340a-4295-8880-e15fc4fe7f78"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 633, 14, 67, "Input",ExpressionUUID->"128e60b1-37e0-4738-bf2f-1069d9251759"],
Cell[CellGroupData[{
Cell[1216, 38, 66469, 1554, 5694, "Input",ExpressionUUID->"c08e9d99-428a-4ea4-aab2-4bcb0204077d"],
Cell[67688, 1594, 1994, 29, 34, "Output",ExpressionUUID->"d2d23976-c510-41c3-8ea0-382bc6e2cc69"],
Cell[69685, 1625, 2709, 54, 98, "Output",ExpressionUUID->"3ce3d44f-4ef4-4c61-8d72-8decbd484800"],
Cell[72397, 1681, 1946, 28, 34, "Output",ExpressionUUID->"ed2fed6d-8b14-412a-9f12-c5315a8874c9"],
Cell[74346, 1711, 8890, 169, 382, "Output",ExpressionUUID->"6ee09212-9812-4f63-a9c2-4988cbf2dbd5"],
Cell[83239, 1882, 9588, 182, 382, "Output",ExpressionUUID->"e6cfc70a-136f-4285-82ff-ce322ec4462d"],
Cell[92830, 2066, 8798, 168, 382, "Output",ExpressionUUID->"a3a1f001-b13c-4008-ba72-3250ce8c5d3d"],
Cell[101631, 2236, 8926, 170, 382, "Output",ExpressionUUID->"da34dba5-e8b0-46e6-9845-21dcb5e25eac"],
Cell[110560, 2408, 8690, 166, 382, "Output",ExpressionUUID->"e9f37c1b-43ad-443e-ab4d-67d5a787941f"],
Cell[119253, 2576, 9501, 181, 382, "Output",ExpressionUUID->"d478c021-19a7-4b02-aee3-3efadd43fd83"],
Cell[128757, 2759, 8805, 168, 382, "Output",ExpressionUUID->"d3c5d0fd-3dfd-4920-9500-b2718a877cee"],
Cell[137565, 2929, 8782, 168, 382, "Output",ExpressionUUID->"850f3b56-d5ef-472f-8a41-fe48d7b6eb95"],
Cell[146350, 3099, 8896, 170, 382, "Output",ExpressionUUID->"f14a3716-57b1-4541-82ce-17147ef6cd10"],
Cell[155249, 3271, 42421, 806, 382, "Output",ExpressionUUID->"095e3a1c-d5ec-4a5a-95f3-8cf016c0011f"],
Cell[197673, 4079, 42804, 817, 382, "Output",ExpressionUUID->"5794bc25-4029-45d8-8291-04ca64915ed2"],
Cell[240480, 4898, 1956, 28, 34, "Output",ExpressionUUID->"0147e482-8b2a-4afd-a955-364de7334249"],
Cell[242439, 4928, 69152, 1345, 377, "Output",ExpressionUUID->"5c07177e-951b-44bc-8af6-671cd149510f"]
}, Open  ]],
Cell[311606, 6276, 154, 3, 30, "Input",ExpressionUUID->"133c3aaf-70d2-4e36-b171-7fc824339cd2"]
}
]
*)

