(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     43701,       1033]
NotebookOptionsPosition[     43386,       1019]
NotebookOutlinePosition[     43745,       1035]
CellTagsIndexPosition[     43702,       1032]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"MODULE", " ", "1"}], ":", " ", 
    RowBox[{"compute", " ", "the", " ", "steady", " ", "state"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SteadyP", "[", 
      RowBox[{
      "\[Alpha]_", ",", "\[Beta]_", ",", "n_", ",", "\[Mu]_", ",", "\[Nu]_", 
       ",", "\[Theta]_", ",", "\[Tau]_"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Specify", " ", "what", " ", "is", " ", "computed"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "sslist", "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "sslist", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sslist", "=", 
         RowBox[{"FindRoot", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"kss", "+", "pss", "-", 
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"wss", "+", 
                  RowBox[{"\[Tau]", "*", "Rss", "*", "pss"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "n"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"(", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"(", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], ")"}], "*", 
                    RowBox[{"(", 
                    SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]], 
                    ")"}]}]], ")"}]}], ")"}]}]], ")"}]}], "\[Equal]", "0"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"kss", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Tau]"}], ")"}], "*", 
                RowBox[{"(", 
                 FractionBox["\[Alpha]", 
                  RowBox[{"\[Nu]", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}]}]], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"\[Nu]", "*", "pss"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
                   SuperscriptBox["pss", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Mu]"}], ")"}]]}]}], ")"}]}]}], 
              "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"wss", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Alpha]"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], ")"}], "/", 
                   "\[Mu]"}]], ")"}]}]}], "\[Equal]", "0"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Rss", "-", 
               RowBox[{"\[Alpha]", "*", 
                RowBox[{"(", 
                 SuperscriptBox["kss", 
                  RowBox[{"\[Alpha]", "-", "1"}]], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], 
                 ")"}]}]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"yss", "-", 
               RowBox[{
                RowBox[{"(", 
                 SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], 
                 ")"}]}]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"revss", "-", 
               RowBox[{"\[Tau]", "*", "Rss", "*", "pss"}]}], "==", "0"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"c1ss", "-", 
               FractionBox[
                RowBox[{"(", 
                 RowBox[{"wss", "+", "revss"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], "*", 
                   SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]]}]}], 
                 ")"}]]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"c2ss", "-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["\[Beta]", 
                  RowBox[{"1", "/", "\[Theta]"}]], "*", 
                 SuperscriptBox["Rss", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "\[Theta]"}], ")"}]], "*", 
                 RowBox[{"(", 
                  RowBox[{"wss", "+", "revss"}], ")"}]}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], "*", 
                   SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]]}]}], 
                 ")"}]]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"savess", "-", 
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"wss", "+", 
                  RowBox[{"\[Tau]", "*", "Rss", "*", "pss"}]}], 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"(", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"(", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], ")"}], "*", 
                    RowBox[{"(", 
                    SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]], 
                    ")"}]}]], ")"}]}], ")"}]], ")"}]}], "\[Equal]", "0"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"kss", ",", "0.06"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"pss", ",", "0.000001"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"wss", ",", "0.20"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Rss", ",", "1.90"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"yss", ",", "0.35"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"revss", ",", "0.00002"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"c1ss", ",", "0.10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"c2ss", ",", "0.14"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"savess", ",", "0.14"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"OUTPUT", " ", "of", " ", "the", " ", "Module"}], " ", 
         "*)"}], "\[IndentingNewLine]", "sslist"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SteadyPold", "[", 
      RowBox[{
      "\[Alpha]_", ",", "\[Beta]_", ",", "n_", ",", "\[Mu]_", ",", "\[Nu]_", 
       ",", "\[Theta]_", ",", "\[Tau]_"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Specify", " ", "what", " ", "is", " ", "computed"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "sslist", "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "sslist", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sslist", "=", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"kss", "+", "pss", "-", 
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"wss", "+", 
                  RowBox[{"\[Tau]", "*", "Rss", "*", "pss"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "n"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"(", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"(", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], ")"}], "*", 
                    RowBox[{"(", 
                    SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]], 
                    ")"}]}]], ")"}]}], ")"}]}]], ")"}]}], "\[Equal]", "0"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"kss", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Tau]"}], ")"}], "*", 
                RowBox[{"(", 
                 FractionBox["\[Alpha]", 
                  RowBox[{"\[Nu]", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}]}]], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"\[Nu]", "*", "pss"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
                   SuperscriptBox["pss", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Mu]"}], ")"}]]}]}], ")"}]}]}], 
              "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"wss", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Alpha]"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], ")"}], "/", 
                   "\[Mu]"}]], ")"}]}]}], "\[Equal]", "0"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Rss", "-", 
               RowBox[{"\[Alpha]", "*", 
                RowBox[{"(", 
                 SuperscriptBox["kss", 
                  RowBox[{"\[Alpha]", "-", "1"}]], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], 
                 ")"}]}]}], "\[Equal]", "0"}]}], "\[IndentingNewLine]", "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{"kss", ",", "pss", ",", "wss", ",", "Rss"}], "}"}], ",", 
           "Reals", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", "6"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"OUTPUT", " ", "of", " ", "the", " ", "Module"}], " ", 
         "*)"}], "\[IndentingNewLine]", "sslist"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"MODULE", " ", "2"}], ":", " ", 
     RowBox[{"compute", " ", "the", " ", "time", " ", "path", " ", "for", " ", 
      SubscriptBox["p", "t"]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DiffEqP", "[", 
      RowBox[{
      "\[Alpha]_", ",", "\[Beta]_", ",", "n_", ",", "\[Mu]_", ",", "\[Nu]_", 
       ",", "\[Theta]_", ",", "\[Tau]_", ",", "pstart_", ",", "tmax_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Specify", " ", "what", " ", "is", " ", "computed"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sslist", ",", "kss", ",", "pss", ",", "wss", ",", "Rss", ",", "yss", 
         ",", "revss", ",", "conlist", ",", "plist", ",", " ", "klist", ",", 
         " ", "wlist", ",", " ", "Rlist", ",", "ylist"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "sslist", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sslist", "=", 
         RowBox[{"FindRoot", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"kss", "+", "pss", "-", 
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"wss", "+", 
                  RowBox[{"\[Tau]", "*", "Rss", "*", "pss"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "n"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"(", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"(", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], ")"}], "*", 
                    RowBox[{"(", 
                    SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]], 
                    ")"}]}]], ")"}]}], ")"}]}]], ")"}]}], "\[Equal]", "0"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"kss", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Tau]"}], ")"}], "*", 
                RowBox[{"(", 
                 FractionBox["\[Alpha]", 
                  RowBox[{"\[Nu]", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}]}]], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"\[Nu]", "*", "pss"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
                   SuperscriptBox["pss", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Mu]"}], ")"}]]}]}], ")"}]}]}], 
              "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"wss", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Alpha]"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], ")"}], "/", 
                   "\[Mu]"}]], ")"}]}]}], "\[Equal]", "0"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Rss", "-", 
               RowBox[{"\[Alpha]", "*", 
                RowBox[{"(", 
                 SuperscriptBox["kss", 
                  RowBox[{"\[Alpha]", "-", "1"}]], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], 
                 ")"}]}]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"yss", "-", 
               RowBox[{
                RowBox[{"(", 
                 SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
                RowBox[{"(", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], 
                 ")"}]}]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"revss", "-", 
               RowBox[{"\[Tau]", "*", "Rss", "*", "pss"}]}], "==", "0"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"c1ss", "-", 
               FractionBox[
                RowBox[{"(", 
                 RowBox[{"wss", "+", "revss"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], "*", 
                   SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]]}]}], 
                 ")"}]]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"c2ss", "-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["\[Beta]", 
                  RowBox[{"1", "/", "\[Theta]"}]], "*", 
                 SuperscriptBox["Rss", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "\[Theta]"}], ")"}]], "*", 
                 RowBox[{"(", 
                  RowBox[{"wss", "+", "revss"}], ")"}]}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["\[Beta]", 
                    RowBox[{"1", "/", "\[Theta]"}]], "*", 
                   SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "\[Theta]"}], ")"}], "-", "1"}]]}]}], 
                 ")"}]]}], "\[Equal]", "0"}]}], "\[IndentingNewLine]", "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"kss", ",", "0.06"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"pss", ",", "0.000001"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"wss", ",", "0.20"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Rss", ",", "1.90"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"yss", ",", "0.35"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"revss", ",", "0.00002"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"c1ss", ",", "0.10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"c2ss", ",", "0.14"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"kss", "=", 
         RowBox[{"kss", "/.", "sslist"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pss", "=", 
         RowBox[{"pss", "/.", "sslist"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"wss", "=", 
         RowBox[{"wss", "/.", "sslist"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Rss", "=", 
         RowBox[{"Rss", "/.", "sslist"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"yss", "=", 
         RowBox[{"yss", "/.", "sslist"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"revss", "=", 
         RowBox[{"revss", "/.", "sslist"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "plist", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"plist", "=", 
         RowBox[{"RecurrenceTable", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"p", "[", 
               RowBox[{"t", "+", "1"}], "]"}], "\[Equal]", 
              RowBox[{
               RowBox[{"(", " ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   FractionBox[
                    RowBox[{
                    SuperscriptBox["kss", "\[Alpha]"], " ", 
                    SuperscriptBox["pss", "\[Mu]"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], ")"}], " ", 
                    "\[Nu]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]", "+", 
                    RowBox[{
                    SuperscriptBox["pss", "\[Mu]"], " ", "\[Nu]"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    FractionBox[
                    RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], 
                    "\[Mu]"]}]]}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}]}]], "+", 
                   FractionBox[
                    RowBox[{"pss", " ", "Rss", " ", "\[Tau]"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}]}]], "+", 
                   FractionBox[
                    RowBox[{
                    SuperscriptBox["kss", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "\[Alpha]"}]], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["pss", 
                    RowBox[{"1", "-", "\[Mu]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], "+", 
                    RowBox[{"pss", " ", "\[Nu]"}]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]", "+", 
                    RowBox[{
                    SuperscriptBox["pss", "\[Mu]"], " ", "\[Nu]"}]}], ")"}], 
                    FractionBox[
                    RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], "\[Mu]"]], 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "\[Tau]"}], ")"}]}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}], " ", 
                    "\[Nu]"}]]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"pss", "+", 
                   FractionBox[
                    RowBox[{"\[Alpha]", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["pss", 
                    RowBox[{"1", "-", "\[Mu]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], "+", 
                    RowBox[{"pss", " ", "\[Nu]"}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "\[Tau]"}], ")"}]}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Nu]"}]], 
                   "-", 
                   RowBox[{
                    SuperscriptBox["kss", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "\[Alpha]"}]], " ", 
                    SuperscriptBox["pss", "\[Mu]"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]", 
                    " ", "\[Nu]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]", "+", 
                    RowBox[{
                    SuperscriptBox["pss", "\[Mu]"], " ", "\[Nu]"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    FractionBox[
                    RowBox[{"1", "-", "\[Alpha]"}], "\[Mu]"]}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"pss", " ", "\[Tau]"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}]}]], "+", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    FractionBox["1", "\[Theta]"]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"wss", "+", 
                    RowBox[{"pss", " ", "Rss", " ", "\[Tau]"}]}], ")"}]}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}], 
                    "2"]}]]}], ")"}]}], "-", 
                   RowBox[{
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Nu]"}]], 
                    RowBox[{
                    SuperscriptBox["kss", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "\[Alpha]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["pss", 
                    RowBox[{"1", "-", "\[Mu]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], "+", 
                    RowBox[{"pss", " ", "\[Nu]"}]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]", "+", 
                    RowBox[{
                    SuperscriptBox["pss", "\[Mu]"], " ", "\[Nu]"}]}], ")"}], 
                    FractionBox[
                    RowBox[{"1", "-", "\[Alpha]"}], "\[Mu]"]], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "\[Tau]"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"pss", " ", "\[Tau]"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}]}]], "+", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    FractionBox["1", "\[Theta]"]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"wss", "+", 
                    RowBox[{"pss", " ", "Rss", " ", "\[Tau]"}]}], ")"}]}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "n"}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["Rss", 
                    RowBox[{"1", "-", 
                    FractionBox["1", "\[Theta]"]}]], " ", 
                    SuperscriptBox["\[Beta]", 
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "\[Theta]"}]]}]}], ")"}], 
                    "2"]}]]}], ")"}]}]}]}], ")"}]}], ")"}], "*", 
               RowBox[{"p", "[", "t", "]"}]}]}], ",", 
             RowBox[{
              RowBox[{"p", "[", "1", "]"}], "\[Equal]", "pstart"}]}], "}"}], 
           ",", "p", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "1", ",", "tmax"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"klist", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             FractionBox["\[Alpha]", 
              RowBox[{"\[Nu]", "*", 
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]"}], ")"}]}]], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Nu]", "*", "pss"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
               SuperscriptBox["pss", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Mu]"}], ")"}]]}]}], ")"}], "*", 
            "plist"}], ")"}], "*", 
          RowBox[{"(", 
           FractionBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Tau]"}], ")"}], "kss"], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"wlist", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Nu]"}], ")"}], "*", 
            RowBox[{"(", 
             SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
            RowBox[{"(", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Nu]", "*", 
                 RowBox[{"(", 
                  SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], ")"}], "/", 
               "\[Mu]"}]], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Alpha]", "*", "klist"}], "+", 
              RowBox[{
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"(", 
                  RowBox[{"1", "-", "\[Alpha]", "-", "\[Mu]"}], ")"}], 
                 "\[Mu]"], ")"}], "*", 
               RowBox[{"(", 
                FractionBox["1", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}]], ")"}], "*", 
               "\[Nu]", "*", "\[Mu]", "*", 
               RowBox[{"(", 
                SuperscriptBox["pss", "\[Mu]"], ")"}], "*", "plist"}]}], 
             ")"}]}], ")"}], "/", "wss"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Rlist", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Alpha]", "*", 
            RowBox[{"(", 
             SuperscriptBox["kss", 
              RowBox[{"\[Alpha]", "-", "1"}]], ")"}], "*", 
            RowBox[{"(", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Nu]", "*", 
                 RowBox[{"(", 
                  SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], ")"}],
             "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Alpha]", "-", "1"}], ")"}], "*", "klist"}], "+", 
              RowBox[{
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"(", 
                  RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Mu]"], ")"}], "*", 
               RowBox[{"(", 
                FractionBox["1", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}]], ")"}], "*", 
               "\[Nu]", "*", "\[Mu]", "*", 
               RowBox[{"(", 
                SuperscriptBox["pss", "\[Mu]"], ")"}], "*", "plist"}]}], 
             ")"}]}], ")"}], "/", "Rss"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ylist", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             SuperscriptBox["kss", "\[Alpha]"], ")"}], "*", 
            RowBox[{"(", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Nu]", "*", 
                 RowBox[{"(", 
                  SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "\[Mu]"}]], ")"}],
             "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Alpha]", "*", "klist"}], "+", 
              RowBox[{
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"(", 
                  RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Mu]"], ")"}], "*", 
               RowBox[{"(", 
                FractionBox["1", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"\[Nu]", "*", 
                    RowBox[{"(", 
                    SuperscriptBox["pss", "\[Mu]"], ")"}]}], "+", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Nu]"}], ")"}]}], ")"}]], ")"}], "*", 
               "\[Nu]", "*", "\[Mu]", "*", 
               RowBox[{"(", 
                SuperscriptBox["pss", "\[Mu]"], ")"}], "*", "plist"}]}], 
             ")"}]}], ")"}], "/", "yss"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"conlist", "=", 
         RowBox[{"{", 
          RowBox[{
          "plist", ",", "klist", ",", "wlist", ",", "Rlist", ",", "ylist"}], 
          "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"OUTPUT", " ", "of", " ", "the", " ", "Module"}], " ", 
         "*)"}], "\[IndentingNewLine]", "conlist"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7733906355465508`*^9, 3.773390641199168*^9}, {
   3.7733911744885063`*^9, 3.773391284795095*^9}, {3.773424451431098*^9, 
   3.773424465588374*^9}, {3.773426511324173*^9, 3.773426584580997*^9}, {
   3.773426694458152*^9, 3.773426697616454*^9}, {3.7734269621388073`*^9, 
   3.773426970930334*^9}, {3.773427017903224*^9, 3.773427027312056*^9}, {
   3.773427059949156*^9, 3.773427070069763*^9}, {3.774029182592208*^9, 
   3.7740291892349653`*^9}, {3.774029226742814*^9, 3.774029345078679*^9}, {
   3.774029383428591*^9, 3.774029388061453*^9}, {3.774029432389908*^9, 
   3.774029454347406*^9}, {3.774029507890869*^9, 3.77402953257694*^9}, {
   3.7740295647165728`*^9, 3.774029565383418*^9}, {3.774029918888555*^9, 
   3.7740299298370657`*^9}, {3.77407368890177*^9, 3.77407370125846*^9}, {
   3.774073864292543*^9, 3.77407387436631*^9}, {3.774180605057741*^9, 
   3.774180606025362*^9}, 3.774181776509666*^9, 3.774182141237218*^9, {
   3.7742481261958513`*^9, 3.774248172415534*^9}, {3.774266287796831*^9, 
   3.7742662886208076`*^9}, {3.7742664642303333`*^9, 3.774266472013401*^9}, {
   3.774269204046775*^9, 3.774269207451996*^9}, {3.774608157333795*^9, 
   3.774608187130958*^9}, {3.774608251217149*^9, 3.774608253903865*^9}, {
   3.774608289615641*^9, 3.77460830861335*^9}, {3.774609629373601*^9, 
   3.774609634899691*^9}, 3.7746096917876797`*^9, 3.7746097221850863`*^9, {
   3.774688467143618*^9, 3.774688529532043*^9}, {3.778386770115007*^9, 
   3.778386819792832*^9}, {3.778386909256852*^9, 3.778386934735033*^9}, {
   3.778386993887697*^9, 3.778387020509713*^9}, {3.778388585639978*^9, 
   3.7783886614516573`*^9}, {3.7787681635896*^9, 3.778768174763776*^9}, {
   3.778768602951158*^9, 3.7787686352521353`*^9}, {3.778772590620072*^9, 
   3.778772669885833*^9}, {3.778772711794677*^9, 3.7787727381829967`*^9}, 
   3.778772784099742*^9, {3.778772941037952*^9, 3.7787729983575583`*^9}, {
   3.778776590024249*^9, 3.778776685898189*^9}, {3.778777257292007*^9, 
   3.77877733699673*^9}, 3.780756892183691*^9, {3.780756954812811*^9, 
   3.7807569661866407`*^9}, 3.7807597734517927`*^9, {3.780760930367889*^9, 
   3.780760930489087*^9}, {3.78076147121496*^9, 3.7807614942372503`*^9}, {
   3.7808505856212254`*^9, 3.780850633224015*^9}},
 FontSize->18,ExpressionUUID->"b098507a-fcde-4e52-963f-342ac24b4900"]
},
WindowSize->{1918, 487},
WindowMargins->{{1282, Automatic}, {Automatic, -760}},
FrontEndVersion->"11.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 5, \
2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 42824, 997, 3378, "Input",ExpressionUUID->"b098507a-fcde-4e52-963f-342ac24b4900"]
}
]
*)

